/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary.ui;

import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.g2d.gallery.GalleryViewer;
import org.simantics.scenegraph.g2d.events.Event;

/**
 * @author Tuukka Lehtonen
 */
public interface SymbolLibraryEventHandler {

    /**
     * @param event the event that occurred
     * @param group the symbol group within which the event occurred or
     *        <code>null</code> if event occurred outside of an existing symbol
     *        group
     * @param viewer the viewer of for the group or <code>null</code> if viewer
     *        is not yet initialized
     * @return <code>true</code> if the handler consumes the event
     */
    boolean handleEvent(Event event, ISymbolGroup group, GalleryViewer viewer);

}
