/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * @author Tuukka Lehtonen
 */
public class DiagramLoadQuery extends ResourceRead<IDiagram> {

    Resource         model;
    Resource         runtime;
    IProgressMonitor monitor;
    ResourceArray    structuralPath;
    IDiagramLoader   loader;
    IHintObservable  initialHints;

    public DiagramLoadQuery(IProgressMonitor monitor, Resource model, Resource resource, Resource runtime, ResourceArray structuralPath, IDiagramLoader loader, IHintObservable initialHints) {
        super(resource);

//        if (runtime == null)
//            throw new IllegalArgumentException("null runtime diagram resource");

        this.model = model;
        this.runtime = runtime;
        this.monitor = monitor;
        this.structuralPath = structuralPath != null ? structuralPath : ResourceArray.EMPTY;
        this.loader = loader;
        this.initialHints = initialHints;
    }

    @Override
    public IDiagram perform(ReadGraph graph) throws DatabaseException {
        return loader.loadDiagram(monitor, graph, graph.getPossibleURI(model), resource, runtime, structuralPath, initialHints);
    }

    @Override
    public boolean equals(Object other) {
        // Make sure that we always receive a new result
        return this == other;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * getClass().hashCode();
    }

}
