/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler;

import java.util.Set;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.TopologicalSelectionExpander;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;

/**
 * This handler responds to the EXPAND_SELECTION command. It attempts to expand
 * the current selection for pointer 0, meaning {@link Selection#SELECTION0}.
 * 
 * @see TopologicalSelectionExpander
 * @see Selection the current diagram selection source
 * 
 * @author Tuukka Lehtonen
 */
public class ExpandSelectionHandler extends AbstractDiagramParticipant {

	private final IStatusLineManager statusLine;
	
    @Dependency Selection selection;

    public ExpandSelectionHandler(IStatusLineManager statusLine) {
    	this.statusLine = statusLine;
    }
    
    @EventHandler(priority = 0)
    public boolean handleExpand(CommandEvent event) {
        if (Commands.EXPAND_SELECTION.equals( event.command )) {
            return expandSelection(0);
        }
        return false;
    }

    /**
     * @param selectionId the id of the selection to expand
     * @return <code>true</code> if the selection changed as a result of the
     *         expansion, <code>false</code> if not
     */
    public boolean expandSelection(int selectionId) {
        Set<IElement> start = selection.getSelection(selectionId);
        TopologicalSelectionExpander expander = new TopologicalSelectionExpander(diagram, start);
        final Set<IElement> expanded = expander.expandedIfChanged();
        if (expanded == null)
            return false;
        selection.setSelection(selectionId, expanded);
        if(statusLine != null) {
        	Display.getDefault().asyncExec(new Runnable() {

				@Override
				public void run() {
		        	statusLine.setMessage("Expanded selection to include " + expanded.size() + " (from " + diagram.getElements().size() + ") items.");
				}
        		
        	});
        }
        return true;
    }

}
