/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler;

import java.util.Map;

import org.simantics.db.RequestProcessor;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public class DiagramSelectionRepresentation implements Representation {

    /**
     * A key for describing a DiagramSelection representation for the Simantics
     * clipboard.
     */
    public static final Key  KEY_DIAGRAM_SELECTION = new KeyOf(DiagramSelection.class);

    private DiagramSelection selection;

    public DiagramSelectionRepresentation(DiagramSelection selection) {
        this.selection = selection;
    }

    @Override
    public Key getKey() {
        return KEY_DIAGRAM_SELECTION;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) {
        return (T) selection;
    }

}
