/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.views.swt.ModelledView;

public class ProfilesView
extends ModelledView {
    protected String configurationURI() {
        return "http://www.simantics.org/Diagram-2.2/ProfilesView";
    }

    protected void inputChanged(IWorkbenchPart part, Object input) {
        this.updateViewDescription(input);
        super.inputChanged(part, input);
    }

    private void updateViewDescription(Object input) {
        if (input instanceof Resource) {
            Resource r = (Resource)input;
            ISessionContext ctx = this.getSessionContext();
            if (ctx != null) {
                try {
                    String desc = (String)ctx.getSession().syncRequest((Read)new ResourceRead<String>(r){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            Resource r = this.resource;
                            Resource config = this.getConfiguration(graph, r);
                            if (config != null) {
                                r = config;
                            }
                            return this.formName(graph, r);
                        }

                        private String formName(ReadGraph graph, Resource r) throws DatabaseException {
                            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                            Resource project = Simantics.getProjectResource();
                            String projectUri = project != null ? graph.getPossibleURI(project) : "";
                            String uri = graph.getPossibleURI(r);
                            if (uri != null) {
                                if (uri.startsWith(projectUri)) {
                                    uri = uri.substring(projectUri.length());
                                }
                                uri = URIStringUtils.unescape((String)uri);
                            }
                            return uri != null ? String.valueOf(name) + " (" + uri + ")" : name;
                        }

                        private Resource getConfiguration(ReadGraph graph, Resource r) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            Resource diagram = graph.getPossibleObject(r, DIA.RuntimeDiagram_HasConfiguration);
                            if (diagram == null) {
                                return r;
                            }
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Resource config = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
                            if (config == null) {
                                return diagram;
                            }
                            return config;
                        }
                    });
                    this.setContentDescription(desc);
                }
                catch (DatabaseException e) {
                    this.setContentDescription(e.getMessage());
                }
            }
            this.setVisible(true);
        } else {
            this.setContentDescription("Profiles not available.");
            this.setVisible(false);
        }
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }
}

