/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile.view;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class CreateEntryAction
extends ModelledActionImpl<Resource> {
    public CreateEntryAction(Resource configuration) {
        super(configuration);
    }

    public void run(final Resource runtimeDiagram) {
        ISelection groupSelection = (ISelection)this.getParameter("http://www.simantics.org/Diagram-2.2/ProfilesView/NewEntryGroup");
        final Resource selectedGroup = (Resource)ISelectionUtils.getSinglePossibleKey((Object)groupSelection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (selectedGroup == null) {
            return;
        }
        ISelection styleSelection = (ISelection)this.getParameter("http://www.simantics.org/Diagram-2.2/ProfilesView/NewEntryStyle");
        final Resource selectedStyle = (Resource)ISelectionUtils.getSinglePossibleKey((Object)styleSelection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (selectedStyle == null) {
            return;
        }
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    String modelURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
                    if (modelURI == null) {
                        return;
                    }
                    Resource model = graph.getPossibleResource(modelURI);
                    if (model == null) {
                        return;
                    }
                    String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Entry", (Resource)model, (Resource)L0.ConsistsOf);
                    Resource newGroup = graph.newResource();
                    graph.claim(newGroup, L0.InstanceOf, DIA.GroupStyleProfileEntry);
                    graph.claimLiteral(newGroup, L0.HasName, (Object)name);
                    graph.claim(newGroup, DIA.ProfileEntry_HasGroup, selectedGroup);
                    graph.claim(newGroup, DIA.ProfileEntry_HasStyle, selectedStyle);
                    graph.claim(model, L0.ConsistsOf, newGroup);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

