package org.simantics.diagram.profile.view;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ISelectionUtils;

public class CreateEntryAction extends ModelledActionImpl<Resource> {

	public CreateEntryAction(Resource configuration) {
		super(configuration);
	}
	
	public void run(final Resource runtimeDiagram) {

		ISelection groupSelection = getParameter(DiagramResource.URIs.ProfilesView_NewEntryGroup);
        final Resource selectedGroup = ISelectionUtils.getSinglePossibleKey(groupSelection, SelectionHints.KEY_MAIN, Resource.class);
        if(selectedGroup == null) return;

		ISelection styleSelection = getParameter(DiagramResource.URIs.ProfilesView_NewEntryStyle);
        final Resource selectedStyle = ISelectionUtils.getSinglePossibleKey(styleSelection, SelectionHints.KEY_MAIN, Resource.class);
        if(selectedStyle == null) return;

        try {
        	
			Simantics.getSession().syncRequest(new WriteRequest() {
				
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
	
					Layer0 L0 = Layer0.getInstance(graph);
					DiagramResource DIA = DiagramResource.getInstance(graph);
			        String modelURI = graph.getPossibleRelatedValue((Resource)runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
			        if (modelURI == null) return;
			        
			        Resource model = graph.getPossibleResource(modelURI);
			        if(model == null) return;
			        
			        String name = NameUtils.findFreshEscapedName(graph, "Entry", model, L0.ConsistsOf);
			        
			        Resource newGroup = graph.newResource();
			        graph.claim(newGroup, L0.InstanceOf, DIA.GroupStyleProfileEntry);
			        graph.claimLiteral(newGroup, L0.HasName, name);
			        graph.claim(newGroup, DIA.ProfileEntry_HasGroup, selectedGroup);
			        graph.claim(newGroup, DIA.ProfileEntry_HasStyle, selectedStyle);
			        graph.claim(model, L0.ConsistsOf, newGroup);
	
				}
	
			});
        	
        } catch (DatabaseException e) {
        	e.printStackTrace();
        }

	}

}
