package org.simantics.diagram.profile.view;

import java.net.URL;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String    PLUGIN_ID = "org.simantics.diagram.profile";

    // The shared instance
    private static Activator      plugin;

    private BundleContext         bundleContext;

    private ServiceTracker<?, ?>  logTracker;

    /**
     * The constructor
     */
    public Activator() {
    }

    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;
    }

    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        if (logTracker != null) {
            logTracker.close();
            logTracker = null;
        }

        this.bundleContext = null;
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    public static URL getDefaultResource(String name) {
        Activator plugin = getDefault();
        if(plugin == null) throw new IllegalStateException("The plugin is not active.");
        return plugin.getBundle().getResource(name);
    }

}
