/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.actions;

import gnu.trove.map.hash.THashMap;

import java.awt.Graphics2D;

import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class MoveAction implements IAction {

    protected RouteGraph rg;
    protected Object target;
    protected RouteGraph movedRg;

    public MoveAction(RouteGraph rg, Object target) {
        this.rg = rg;
        this.target = target;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double x, double y) {
        THashMap<Object, Object> map = new THashMap<Object, Object>();
        movedRg = rg.copy(map);
        move(movedRg, map.get(target), x, y);
        renderer.render(g, movedRg);
    }

    public RouteGraph getRouteGraph() {
        return movedRg == null ? rg : movedRg;
    }

    public Object getTarget() {
        return target;
    }

    public void finish(double x, double y) {
        move(rg, target, x, y);
        movedRg = null;
    }

    protected void move(RouteGraph rg, Object target, double x, double y) {
        moveTarget(rg, target, x, y);
    }

    private static void moveTarget(RouteGraph rg, Object target, double x, double y) {
        if(target instanceof RouteLine) {
            RouteLine line = (RouteLine)target;
            rg.setLocation(line, x, y);
        }
        else if(target instanceof RouteTerminal) {
            RouteTerminal terminal = (RouteTerminal)target;
            rg.setLocation(terminal, x, y);
        }
        else if(target instanceof RouteLink) {
            RouteLink link = (RouteLink)target;
            RouteLine a = link.getA();
            RouteLine b = link.getB();
            rg.setLocation(a, x, y);
            rg.setLocation(b, x, y);
        }
    }

    public static MoveAction create(RouteGraph rg, double x, double y) {
        return create(rg, x, y, TOLERANCE);
    }

    public static MoveAction create(RouteGraph rg, double x, double y, double tolerance) {
        Object target = rg.pick(x, y, tolerance);
        if(target == null)
            return null;
        else
            return new MoveAction(rg, target);
    }

    public static MoveAction create(RouteGraph rg, double x, double y, double tolerance, TargetFilter filter) {
        Object target = rg.pick(x, y, tolerance);
        if (target != null && (filter == null || filter.accept(target)))
            return new MoveAction(rg, target);
        return null;
    }

    public static interface TargetFilter {
        boolean accept(Object target);
    }

}
