/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.desktop.ui.internal;

import java.util.Collection;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.modeling.ModelingUtils;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ExportModel extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        
    	try {
    		
			Resource lib = Simantics.sync(new UniqueRead<Resource>() {

				@Override
				public Resource perform(ReadGraph graph) throws DatabaseException {
					Collection<Resource> models = graph.sync(new ProjectModels(Simantics.getProjectResource()));
					if(models.size() == 1) return models.iterator().next();
					return null;
				}
				
			});
			if(lib == null) return null;
			
            IHintContext context = new AdaptableHintContext(SelectionHints.KEY_MAIN);
            context.setHint(SelectionHints.KEY_MAIN, lib);

			IStructuredSelection sel = new StructuredSelection(context);
	    	ModelingUtils.openWizard(Display.getCurrent(), sel, "org.simantics.modeling.ui.modelExportWizard"); //$NON-NLS-1$
		} catch (DatabaseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	return null;
        
    }

}
