/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.internal.rewriters;

import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.BreadcrumbSection;
import org.simantics.debug.browser.sections.RawStatementsSection;
import org.simantics.layer0.Layer0;

public enum BreadcrumbCreator implements ResourceBrowserRewriter
{
    INSTANCE;


    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content) throws DatabaseException {
        ArrayList<BreadcrumbSection.Node> nodes = new ArrayList<BreadcrumbSection.Node>();
        BreadcrumbCreator.collectBreadcrumbs(graph, nodes, content.resource);
        if (!nodes.isEmpty()) {
            content.putSection(BreadcrumbSection.class, new BreadcrumbSection(nodes.toArray(new BreadcrumbSection.Node[nodes.size()])));
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            RawStatementsSection rawStatementsSection = content.getSection(RawStatementsSection.class);
            rawStatementsSection.statementsByPredicates.remove((Object)L0.HasName);
            rawStatementsSection.statementsByPredicates.remove((Object)L0.PartOf);
        }
    }

    private static void collectBreadcrumbs(ReadGraph graph, ArrayList<BreadcrumbSection.Node> nodes, Resource resource) throws DatabaseException {
        if (resource.equals(graph.getRootLibrary())) {
            nodes.add(new BreadcrumbSection.Node("", "http:/", resource.getResourceId()));
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent != null) {
            BreadcrumbCreator.collectBreadcrumbs(graph, nodes, parent);
            String name = (String)graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
            if (name != null) {
                nodes.add(new BreadcrumbSection.Node("/", name, resource.getResourceId()));
            } else {
                nodes.add(new BreadcrumbSection.Node("/", String.valueOf(resource.getResourceId()), resource.getResourceId()));
            }
            return;
        }
        Statement propertyInverseStatement = graph.getPossibleStatement(resource, L0.PropertyOf);
        if (propertyInverseStatement != null) {
            BreadcrumbCreator.collectBreadcrumbs(graph, nodes, propertyInverseStatement.getObject());
            String name = (String)graph.getPossibleRelatedValue(graph.getInverse(propertyInverseStatement.getPredicate()), L0.HasName, (Binding)Bindings.STRING);
            nodes.add(new BreadcrumbSection.Node("#", name, resource.getResourceId()));
            return;
        }
        Resource assertion = graph.getPossibleObject(resource, L0.HasObjectInverse);
        if (assertion != null && (parent = graph.getPossibleObject(assertion, L0.Asserts_Inverse)) != null) {
            String name;
            BreadcrumbCreator.collectBreadcrumbs(graph, nodes, parent);
            Resource predicate = graph.getPossibleObject(assertion, L0.HasPredicate);
            String string = name = predicate == null ? null : (String)graph.getPossibleRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
            if (name != null) {
                nodes.add(new BreadcrumbSection.Node("#assertion#", name, resource.getResourceId()));
            } else {
                nodes.add(new BreadcrumbSection.Node("#assertion#", String.valueOf(resource.getResourceId()), resource.getResourceId()));
            }
            return;
        }
    }

    @Override
    public double getPriority() {
        return 1.0;
    }
}

