/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Platform;

/**
 * @author Tuukka Lehtonen / Semantum Oy
 */
public class PlatformPropertyTester extends PropertyTester {

    private static final String PROPERTY_IN_DEVELOPMENT_MODE = "inDevelopmentMode"; //$NON-NLS-1$

    @Override
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IN_DEVELOPMENT_MODE.equals(property)) {
            return parseBoolean(expectedValue, true) == Platform.inDevelopmentMode();
        }
        return false;
    }

    private boolean parseBoolean(Object value, boolean defaultValue) {
        if (value instanceof Boolean) return (Boolean) value;
        if (value instanceof String) return Boolean.parseBoolean((String) value);
        return defaultValue;
    }

}
