/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.utils.ResourceInfo;

public class TypeHierarchySection implements ResourceBrowserSection {

    public static class Node {
        public final String relation;
        public final ResourceInfo type;
        public final Node[] superTypes;
        public final int height;
        public final int width;
        
        public Node(String relation, ResourceInfo type, Node[] superTypes) {
            this.relation = relation;
            this.type = type;
            this.superTypes = superTypes;
            this.height = sumHeights(superTypes);
            this.width = maxWidths(superTypes);
        }
    }
    
    Node root;
    
    public TypeHierarchySection(Node root) {
        this.root = root;
    }

    private static int sumHeights(Node[] nodes) {
        int sum = 0;
        for(Node node : nodes)
            sum += node.height;
        if(sum == 0)
            sum = 1;
        return sum;
    }
    
    private static int maxWidths(Node[] nodes) {
        int max = 0;
        for(Node node : nodes)
            if(node.width > max)
                max = node.width;
        return max+1;
    }
    
    @Override
    public double getPriority() {
        return 1;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out)
            throws DatabaseException {
        Node[][] table = new Node[root.height][root.width-1];
        fillTable(table, root, 0, 0);
        
        if (root.width - 1 > 0) {
            out.println("<div id=\"typeHierarchyContent\">");
            out.println("<table>");
            for(int j=0;j<root.height;++j) {
                out.println("\t<tr>");
                for(int i=0;i<root.width-1;++i) {
                    Node node = table[j][i];
                    if(node != null) {
                        out.print("\t\t<td rowspan=\""+node.height+"\">");
                        out.print(node.relation + " " + node.type);
                        out.println("</td>");
                    }
                }
                out.println("\t</tr>");
            }
            out.println("</table>");
            out.println("</div>");
        }
    }

    private static void fillTable(Node[][] table, Node node, int i, int j) {
        for(Node child : node.superTypes) {
            table[j][i] = child;
            fillTable(table, child, i+1, j);
            j += child.height;
        }
    }

}
