/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.service;

import org.simantics.db.service.ClusterUID;

public final class ResourceUID {
    public static final ResourceUID Null = new ResourceUID(null);
    private final ClusterUID clusterUID;
    private final short index;

    private ResourceUID(ResourceUID a) {
        assert (a == null);
        this.clusterUID = ClusterUID.Null;
        this.index = 0;
    }

    public ResourceUID(long first, long second, long index) {
        this.clusterUID = ClusterUID.make(first, second);
        if (index < 1L || index > 16384L) {
            throw new IllegalArgumentException("Trying to create illegal resource. index=" + index + " cluster=" + this.clusterUID);
        }
        this.index = (short)index;
    }

    public ResourceUID(long[] longs, int offset) {
        if (longs.length < offset + 3) {
            throw new IllegalArgumentException("Not enough data to create resource uid. length=" + longs.length + " offset=" + offset);
        }
        this.clusterUID = ClusterUID.make(longs[offset + 0], longs[offset + 1]);
        this.index = (short)longs[offset + 2];
        if (this.index < 1 || this.index > 16384) {
            throw new IllegalArgumentException("Trying to create illegal resource. index=" + this.index + " cluster=" + this.clusterUID);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public ClusterUID asCID() {
        return this.clusterUID;
    }

    public static ResourceUID parseToString(String s) {
        String[] ss = s.split("\\.");
        if (ss.length != 3) {
            throw new IllegalArgumentException("'" + s + "' is not a valid serialized ResourceUID");
        }
        long first = Long.parseLong(ss[0]);
        long second = Long.parseLong(ss[1], 16);
        short index = Short.parseShort(ss[2]);
        return new ResourceUID(first, second, index);
    }

    public static ResourceUID parse(String s) {
        String[] ss = s.split("#");
        if (ss.length != 3) {
            throw new IllegalArgumentException("'" + s + "' is not a valid serialized ResourceUID");
        }
        long first = Long.parseLong(ss[0]);
        long second = Long.parseLong(ss[1]);
        short index = Short.parseShort(ss[2]);
        return new ResourceUID(first, second, index);
    }

    public String serialized() {
        return "0#" + this.clusterUID.second + "#" + this.index;
    }

    public void toLong(long[] longs, int offset) {
        int i = this.clusterUID.toLong(longs, offset);
        longs[i] = this.index;
    }

    public String toString() {
        return String.valueOf(this.clusterUID.toString()) + "." + this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceUID)) {
            return false;
        }
        ResourceUID x = (ResourceUID)o;
        return this.clusterUID.equals(x.clusterUID) && this.index == x.index;
    }

    public int hashCode() {
        int result = this.clusterUID.hashCode();
        result = 31 * result + this.index;
        return result;
    }
}

