package org.simantics.db.testing.impl;

import org.eclipse.core.runtime.Platform;

/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

public class Configuration {
    public final boolean purge = false; // Used to test purge.
    public final boolean debug = false; // Used to initialize DEBUG flag on various places.
    public final boolean remoteCore = false; // If true connects to remote core.
    public final boolean useJournal = false;
    public final boolean useFailedTests;
    public final boolean virtual;
    public final boolean transactionKeep;
//    public final String driverName;
    public final String workspace = "../../";
    public final String coreDir = Platform.getLocation().append("db").toFile().getAbsolutePath();
    public final String host = "127.0.0.1";
//    public final String host = "Linux-64-Ubuntu-1";
//    public final String host = "Espvm3k973";
    public final int port = (remoteCore) ? 6666 : 0;
    public final boolean skipServerCreation = (remoteCore) ? true : false;
    public final String username = "Default User";
    public final String password = "";
    public final int connectionReconnectCount;
    public final int connectionThreadCount;
    public final int connectionSaveCount;
    public final int connectionInstanceCount;
    public final int modellingLoopCount;
    public final int modellingOpCount;
    public final String textIndexingFile;
    public final int rwQueryThreds;
    public final int rwQueryCount;
    public final int importOuterCount;
    public final int importInnerCount;
    public final int cachedClusterCount;  // limited by the number of bits reserved for clusters (32768 for now and system needs a few)
    public final int cachedClusterRounds;
    public final int generateCount;
    public final String generateModel;
    public final int publishLoopCount;
    public final int collectedLoopCount;
    public final int refreshLoopCount;
    public final int refreshAddCount;
    public final int callLoopCount;
    public final int callCallCount;
    public final int callThreadCount;
    public final int i3199ResourceCount;
    public final int i3176BlockCount;
    public final int i3176BigBlockCount;
    public final int i1659LoopCount;
    public final String databaseInitFile = "graph.txt";
    private static Configuration current = new Configuration();

    protected Configuration() {
        String configuration = System.getProperty("test.configuration", "regression");
        virtual = System.getProperty("test.graph.impl", "").equals("virtual");
//        driverName = virtual ? ProCoreDriver.ProCoreDriverNameVirtual : ProCoreDriver.ProCoreDriverName;
        transactionKeep = System.getProperty("test.transaction.policy", "keep").equals("keep");
        useFailedTests = System.getProperty("test.use.failed", "false").equals("true");
        @SuppressWarnings("unused")
        String timeout = System.getProperty("test.exit.timeout", "30000");
        if (configuration.equals("stress")) {
            connectionReconnectCount = 100;
            connectionThreadCount = 10;
            connectionSaveCount = 10;
            connectionInstanceCount = 10;
            modellingLoopCount = 1000;
            modellingOpCount = 1000;
            textIndexingFile = "./data/cprrn10.txt";
            rwQueryThreds = 10;
            rwQueryCount = 1000000;
            importOuterCount = 10;
            importInnerCount = 100000;
            cachedClusterCount = 4096;
            cachedClusterRounds = 10;
            generateCount = 1000;
            generateModel = "devs";
            publishLoopCount = 200;
            collectedLoopCount = 1000;
            refreshLoopCount = 2;
            refreshAddCount = 1000000;
            callLoopCount = 2;
            callCallCount = 100000;
            callThreadCount = 100;
            i3199ResourceCount = 100 * 1000 * 1000;
            i3176BlockCount = 1000;
            i3176BigBlockCount = 5000;
            i1659LoopCount = 100;
        } else { // regression
            connectionReconnectCount = 2;
            connectionThreadCount = 1;
            connectionSaveCount = 1;
            connectionInstanceCount = 1;
            modellingLoopCount = 2;
            modellingOpCount = 100;
            textIndexingFile = "./data/cprrn00.txt";
            rwQueryThreds = 1;
            rwQueryCount = 100;
            importOuterCount = 10;
            importInnerCount = 100;
            cachedClusterCount = 10;
            cachedClusterRounds = 2;
            generateCount = 1;
            generateModel = "test";
            publishLoopCount = 2;
            collectedLoopCount = 1;
            refreshLoopCount = 2;
            refreshAddCount = 100;
            callLoopCount = 2;
            callCallCount = 100;
            callThreadCount = 10;
            i3199ResourceCount = 200 * 1000;
            i3176BlockCount = 2;
            i3176BigBlockCount = 10;
            i1659LoopCount = 10;
        }
    }
    public static Configuration get() {
        return current;
    }
}
