package org.simantics.db.service;

public interface ExternalOperation {
	/**
	 * Undoes the operation. If operation is disposed, does nothing.
	 */
	void undo();

	/**
	 * Redoes the operation. If operation is disposed, does nothing.
	 */
	void redo();

	/**
	 * Tells if external operation is still valid. For example operations
	 * related to experiments are disposed when the experiment is disposed.
	 */
	boolean isDisposed();
}
