package org.simantics.db.service;


final public class Bytes {

	final public static void write(byte[] bytes, int index, byte value) {
		bytes[index] = value;
	}

	final public static void writeLE(byte[] bytes, int index, long value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		bytes[index++] = (byte) ((value >>> 16) & 0xFF);
		bytes[index++] = (byte) ((value >>> 24) & 0xFF);
		bytes[index++] = (byte) ((value >>> 32) & 0xFF);
		bytes[index++] = (byte) ((value >>> 40) & 0xFF);
		bytes[index++] = (byte) ((value >>> 48) & 0xFF);
		bytes[index++] = (byte) ((value >>> 56) & 0xFF);
		
	}

	final public static void writeLE6(byte[] bytes, int index, long value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		bytes[index++] = (byte) ((value >>> 16) & 0xFF);
		bytes[index++] = (byte) ((value >>> 24) & 0xFF);
		bytes[index++] = (byte) ((value >>> 32) & 0xFF);
		bytes[index++] = (byte) ((value >>> 40) & 0xFF);
		
	}

	final public static void writeLE7(byte[] bytes, int index, long value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		bytes[index++] = (byte) ((value >>> 16) & 0xFF);
		bytes[index++] = (byte) ((value >>> 24) & 0xFF);
		bytes[index++] = (byte) ((value >>> 32) & 0xFF);
		bytes[index++] = (byte) ((value >>> 40) & 0xFF);
		bytes[index++] = (byte) ((value >>> 48) & 0xFF);
		
	}
	
	final public static void writeLE8(byte[] bytes, int index, long value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		bytes[index++] = (byte) ((value >>> 16) & 0xFF);
		bytes[index++] = (byte) ((value >>> 24) & 0xFF);
		bytes[index++] = (byte) ((value >>> 32) & 0xFF);
		bytes[index++] = (byte) ((value >>> 40) & 0xFF);
		bytes[index++] = (byte) ((value >>> 48) & 0xFF);
		bytes[index++] = (byte) ((value >>> 56) & 0xFF);
		
	}

	final public static void writeLE(byte[] bytes, int index, int value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		bytes[index++] = (byte) ((value >>> 16) & 0xFF);
		bytes[index++] = (byte) ((value >>> 24) & 0xFF);
		
	}

	final public static void writeLE(byte[] bytes, int index, short value) {
		
		bytes[index++] = (byte) (value & 0xFF);
		bytes[index++] = (byte) ((value >>> 8) & 0xFF);
		
	}
	
	final public static byte read(byte[] bytes, int byteIndex) {
		return bytes[byteIndex++];
	}

	final public static int readLE2(byte[] bytes, int byteIndex) {
		int result = (int) 
    			(((int)(bytes[byteIndex++] & 0xff)) | 
    			(((int)(bytes[byteIndex++] & 0xff))<<8)); 
    		return result;
	}

	final public static int readLE4(byte[] bytes, int byteIndex) {
		int result = (int) 
    			(((int)(bytes[byteIndex++] & 0xff)) | 
    			(((int)(bytes[byteIndex++] & 0xff))<<8) | 
    			(((int)(bytes[byteIndex++] & 0xff))<<16) | 
    			(((int)(bytes[byteIndex++] & 0xff))<<24)); 
    		return result;
	}
	
	final public static long readLE7(byte[] bytes, int byteIndex) {
		long result = (long) 
    			(((long)(bytes[byteIndex++] & 0xff)) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<8) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<16) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<24) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<32) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<40) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<48));
		return result;
	}

	final public static long readLE8(byte[] bytes, int byteIndex) {
		long result = (long) 
    			(((long)(bytes[byteIndex++] & 0xff)) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<8) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<16) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<24) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<32) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<40) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<48) | 
    			(((long)(bytes[byteIndex++] & 0xff))<<56));
		return result;
	}
		
}
