package org.simantics.db.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;

/**
 * 
 * An interface representing a modification into the semantic database with a result value.
 * <ul>
 * <li>{@link WriteRequest} for writing with no result value
 * <li>{@link WriteOnlyRequest} for writing in write only mode
 * <li>{@link DelayedWriteRequest} for writing in delayed write mode
 * </ul>
 * <p>
 * 
 * The client is not expected to implement this class but rather to extend one of the standard implementations.
 * 
 * @version 1.5
 * @author Antti Villberg
 * @see ReadInterface
 * @see RequestProcessor
 * @see ReadGraph
 * @see Session
 */

public interface WriteInterface<Result> {

	Result request(RequestProcessor processor) throws DatabaseException;
	void request(AsyncRequestProcessor processor, Procedure<Result> procedure);
	
}
