/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procedure;

import org.simantics.db.AsyncReadGraph;

/**
 * @author Antti Villberg
 * 
 * First execute is called k times. After this finished or exception is called exactly once.
 *
 * @param <Result> the result object type accepted by the procedure
 */
public interface AsyncContextMultiProcedure<Context, Result> {

    /**
     * Invoked once for each separate result of the request with potentially
     * multiple results. It shall be guaranteed that all <code>execute</code>
     * invocations have been completed when either
     * {@link #finished(AsyncReadGraph)} or
     * {@link #exception(AsyncReadGraph, Throwable)} are called and that no
     * <code>execute</code> invocations will follow afterwards.
     * 
     * @param graph asynchronous graph access
     * @param result a single result of the multiresult procedure
     */
    void execute(AsyncReadGraph graph, Context context, Result result);

    /**
     * Invoked after all {@link #execute(AsyncReadGraph, Object)} calls have
     * been finished successfully. This method will not be invoked if case of
     * errors in {@link #execute(AsyncReadGraph, Object)} or the performed
     * request that provides the results to this procedure.
     * 
     * @param graph asynchronous graph access
     */
    void finished(AsyncReadGraph graph, Context context);

    /**
     * If an error occurs in the processing of the database request that
     * produces the results for this procedure.
     * 
     * @param graph asynchronous graph access
     * @param throwable the exception that occurred
     */
    void exception(AsyncReadGraph graph, Throwable throwable);

}
