/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.protocol;

import org.simantics.db.server.protocol.AbstractMessage;
import org.simantics.db.server.protocol.DataBuffer;

public abstract class AbstractFunction
extends AbstractMessage {
    private int token = 0;

    void setToken(int token) {
        this.token = token;
    }

    int getToken() {
        return this.token;
    }

    AbstractFunction(int requestNumber, int responseNumber) {
        super(requestNumber, responseNumber);
    }

    AbstractFunction(int requestNumber, int responseNumber, DataBuffer buffer) {
        super(requestNumber, responseNumber, buffer);
    }

    @Override
    boolean isEvent() {
        return false;
    }

    @Override
    String getExceptionText() {
        String t = super.getExceptionText();
        if (t != null) {
            return super.getExceptionText();
        }
        if (this.notRightDataForUs()) {
            return "Response type does not match.";
        }
        return null;
    }

    public boolean hasException() {
        return this.notRightDataForUs() || super.getExceptionText() != null;
    }

    boolean notRightDataForUs() {
        return this.receivedNumber != this.responseNumber;
    }

    void prepareForSendingRequest() {
        this.receivedNumber = 0;
        this.responsePending = true;
        super.setExceptionText(null);
    }

    boolean hasResponsePending() {
        return this.hasResponse() && this.responsePending;
    }

    @Override
    synchronized void gotResponse() {
        this.responsePending = false;
        this.notify();
    }
}

