/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Client;
import org.simantics.db.server.internal.DatabaseI;
import org.simantics.db.server.internal.SessionI;

class SessionManager {
    private ConcurrentHashMap<Client, SessionI> sessionMap = new ConcurrentHashMap();

    SessionManager() {
    }

    public List<Client> disconnect(DatabaseI db) throws ProCoreException {
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Map.Entry<Client, SessionI> i : this.sessionMap.entrySet()) {
            Client client;
            SessionI si = i.getValue();
            if (!db.equals(si.getDb()) || !(client = i.getKey()).isOpen()) continue;
            client.close();
            clients.add(client);
        }
        return clients;
    }

    public void connect(DatabaseI db, List<Client> clients) throws ProCoreException, InterruptedException {
        for (Client client : clients) {
            SessionI si = this.sessionMap.get(client);
            if (si == null || !db.equals(si.getDb())) continue;
            client.open();
        }
    }

    public SessionI newSession(DatabaseI db) throws ProCoreException {
        Client client = db.newClient();
        SessionI si = new SessionI(db, client);
        this.sessionMap.put(client, si);
        return si;
    }
}

