/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.server.DatabaseLastExitException;
import org.simantics.db.server.GuardFileVersionException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.ServerNotFoundException;
import org.simantics.db.server.internal.Activator;
import org.simantics.db.server.internal.Client;
import org.simantics.db.server.internal.ProCoreClient;
import org.simantics.db.server.internal.ServerAddress;
import org.simantics.db.server.internal.SessionAddress;
import org.simantics.db.server.internal.TailException;
import org.simantics.db.server.internal.TailReadException;
import org.simantics.db.server.internal.Util;
import org.slf4j.LoggerFactory;

public class ProCoreServer {
    private static Map<String, ProCoreServer> workingDirs = new HashMap<String, ProCoreServer>();
    private static Map<String, ProCoreServer> databaseIds = new HashMap<String, ProCoreServer>();
    private static final String LOCALHOST = "127.0.0.1";
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 4;
    public static final String BRANCH_DIR = "procore.headClusters.procore";
    public static final String TAIL_DIR = "procore.tailClusters.procore";
    public static final String TAIL_FILE = "procore.tail.procore";
    public static final String CONFIG_FILE = "procore.config.procore";
    public static final String GUARD_FILE = "procore.guard.procore";
    public static final String JOURNAL_FILE = "procore.journal.procore";
    public static final String LOG_FILE = "procore.log.procore";
    public static final String DCS_FILE = "procore.dumpChangeSets.procore";
    public static final String RECOVERY_NEEDED_FILE = "recovery.needed";
    public static final String RECOVERY_IGNORED_FILE = "recovery.ignored";
    public static final String PROTOCOL_IGNORED_FILE = "protocol.ignored";
    public static final String PAGE_FILE_PATTERN = "procore.page*.procore";
    public static final String DATA_PREFIX = "ClusterData.";
    public static final String DATA_PATTERN = "ClusterData.*";
    public static final String INDEX_PREFIX = "ClusterIndex.";
    public static final String INDEX_PATTERN = "ClusterIndex.*";
    public static final String VALUE_PREFIX = "ExternalValue.";
    public static final String VALUE_PATTERN = "ExternalValue.*";
    public static final String VALUE_SUFFIX = ".procore";
    public static final String DELETED_PREFIX = "ClusterDeleted.";
    public static final String DELETED_PATTERN = "ClusterDeleted.*";
    private static final boolean DEBUG = false;
    public static final String QUIT_CMD = "quit";
    private String databaseId = null;
    private final GuardFile guardFile;
    private final ProCoreClient proCoreClient;
    private final ProCoreProcess proCoreProcess;

    private static boolean isRunning(String aPid) throws ProCoreException {
        boolean isRunning = false;
        try {
            switch (OSType.calculate()) {
                case WINDOWS: {
                    Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh /fi \"pid eq " + aPid + "\"");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = input.readLine();
                    if (line.matches(".*ProCoreServer.exe.*")) {
                        isRunning = true;
                    }
                    input.close();
                    break;
                }
                case UNIX: {
                    Process p = Runtime.getRuntime().exec("ps -p " + aPid + " -o comm=");
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = input.readLine();
                    if (line.matches(".*ProCoreServer.*")) {
                        isRunning = true;
                    }
                    input.close();
                }
            }
        }
        catch (Exception e) {
            throw new ProCoreException("Could not get list of running processes.", e);
        }
        return isRunning;
    }

    public static boolean ignoreProtocolVersion(File dbFolder) {
        if (dbFolder == null) {
            return false;
        }
        return Files.exists(dbFolder.toPath().resolve(PROTOCOL_IGNORED_FILE), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProCoreServer getProCoreServer(File serverDir, File workingDir) throws ProCoreException, ServerNotFoundException {
        try {
            Map<String, ProCoreServer> map = workingDirs;
            synchronized (map) {
                ProCoreServer proCoreServer = workingDirs.get(workingDir.getCanonicalPath());
                if (proCoreServer != null) {
                    return proCoreServer;
                }
                if (!serverDir.isDirectory()) {
                    throw new ProCoreException("Expected server directory as argument");
                }
                if (!workingDir.isDirectory()) {
                    throw new ProCoreException("Expected working directory as argument. wd=" + workingDir.getAbsolutePath());
                }
                String exeSuffix = Activator.getExeSuffix();
                File executable = new File(serverDir, "ProCoreServer" + exeSuffix);
                proCoreServer = new ProCoreServer(executable, workingDir);
                workingDirs.put(workingDir.getCanonicalPath(), proCoreServer);
                return proCoreServer;
            }
        }
        catch (IOException e) {
            throw new ProCoreException("IOException", e);
        }
    }

    public static void logVersionInformation() {
        StringBuilder msg = new StringBuilder(200);
        String nl = " \n";
        msg.append("ProCore version information:");
        msg.append(nl);
        msg.append("ProCoreServer version=1.4 protocol=24.1");
        try {
            msg.append(" folder=" + Activator.getServerFolder());
        }
        catch (IOException iOException) {
            msg.append(" folder information not available");
        }
        msg.append(nl);
        msg.append("svn id=$Id: ProCoreServer.java r31684 2015-09-10 13:45:00Z $");
        String str = msg.toString();
        LoggerFactory.getLogger(ProCoreServer.class).info(str);
    }

    /*
     * Exception decompiling
     */
    private static String[] getFileLines(File aFile, int maxLines) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int parseInt(String s) throws ProCoreException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            String msg = "Could not convert string to number. string=" + s;
            Logger.defaultLogError((String)msg);
            throw new ProCoreException(msg, e);
        }
    }

    ProCoreClient getProCoreClient() {
        return this.proCoreClient;
    }

    private ProCoreServer(File exeFile, File workingDir) throws ProCoreException {
        if (exeFile == null) {
            throw new ProCoreException("Illegal argument: exeFile is null.");
        }
        if (workingDir == null) {
            throw new ProCoreException("Illegal argument: workingDir is null.");
        }
        this.guardFile = new GuardFile(workingDir);
        this.proCoreClient = new ProCoreClient(this);
        this.proCoreProcess = new ProCoreProcess(exeFile, workingDir);
        Util.log("ProCoreServer exe: " + exeFile);
        Util.log("ProCoreServer folder: " + workingDir);
        ProCoreServer.logVersionInformation();
    }

    public synchronized String execute(String command) throws ProCoreException, InterruptedException {
        return this.proCoreClient.execute(command);
    }

    private void startInternal() throws ProCoreException {
        Object exception;
        if (this.proCoreClient.isConnected()) {
            return;
        }
        try {
            this.proCoreProcess.tryToStart();
            int port = this.proCoreProcess.getPort();
            SessionAddress sa = new SessionAddress(new InetSocketAddress(LOCALHOST, port), true);
            this.proCoreClient.connect(sa);
            return;
        }
        catch (InterruptedException e) {
            Util.logError("ProCoreProcess start was interrupted.", e);
            exception = e;
        }
        catch (DatabaseLastExitException e) {
            throw e;
        }
        catch (ProCoreException e) {
            Util.logError("Failed to start ProCoreServer process.", (Throwable)((Object)e));
            exception = e;
        }
        boolean isActive = this.guardFile.isActive(this.proCoreClient);
        if (!isActive) {
            throw new ProCoreException("Failed to connect to ProCoreServer.", (Throwable)exception);
        }
    }

    public synchronized boolean isActive() throws ProCoreException {
        if (!this.proCoreClient.isConnected()) {
            return this.guardFile.isActive(this.proCoreClient);
        }
        this.proCoreClient.execute("");
        return true;
    }

    public synchronized boolean isAlive() throws ProCoreException {
        if (this.proCoreClient.isConnected()) {
            return true;
        }
        if (this.proCoreProcess.isActive()) {
            return true;
        }
        return this.guardFile.isAlive();
    }

    Client newClient() throws ProCoreException {
        if (this.proCoreClient.isConnected()) {
            return this.proCoreClient.newClient();
        }
        int port = this.getPort();
        InetSocketAddress isa = new InetSocketAddress(LOCALHOST, port);
        return this.proCoreClient.newClient(this, isa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryToStop() throws ProCoreException {
        ProCoreClient proCoreClient = this.proCoreClient;
        synchronized (proCoreClient) {
            ProCoreException ex;
            block21: {
                ex = null;
                if (!this.proCoreClient.isConnected() && !this.proCoreProcess.isActive()) {
                    try {
                        this.proCoreClient.connect(this.getPort());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.proCoreClient.isConnected()) {
                    String s = "";
                    try {
                        s = this.proCoreClient.execute(QUIT_CMD);
                        String t = s.replaceAll("\n", "");
                        int n = Integer.parseInt(t);
                        if (n != 1) {
                            Util.log("Number of connections after quit command is " + n + ".");
                        }
                        this.proCoreClient.closeClient(0);
                        if (!this.isLocal() && n > 1) {
                            throw new ProCoreException("More than one connection for remote. n=" + n);
                        }
                    }
                    catch (NumberFormatException e) {
                        Util.logError("Failed to parse number of connections. s=" + s, e);
                        this.proCoreClient.disconnect();
                        break block21;
                    }
                    catch (ProCoreException e) {
                        try {
                            ex = e;
                            break block21;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.proCoreClient.disconnect();
                        }
                    }
                    this.proCoreClient.disconnect();
                }
            }
            try {
                this.proCoreProcess.tryToStop();
            }
            finally {
                if (this.proCoreProcess.isActive() && ex == null) {
                    ex = new ProCoreException("Failed to stop ProCoreProcess.");
                }
            }
            if (ex != null) {
                throw ex;
            }
            return !this.proCoreClient.isConnected() && !this.proCoreProcess.isActive();
        }
    }

    public synchronized boolean isConnected() throws ProCoreException {
        return this.proCoreClient.isConnected();
    }

    public synchronized boolean isLocal() throws ProCoreException {
        return this.proCoreClient.isConnected() && this.proCoreProcess.isActive();
    }

    public synchronized void disconnect() throws ProCoreException {
        this.proCoreClient.disconnect();
    }

    public synchronized void connect() throws ProCoreException, InterruptedException {
        int port = this.getPort();
        if (port == 0) {
            throw new ProCoreException("Port 0 not supported as connection address.");
        }
        this.proCoreClient.connect(port);
    }

    private String getExitMessage(int exitValue) {
        switch (exitValue) {
            default: {
                return "Unexpected exit value = " + exitValue + ".";
            }
            case 1: {
                return "Exception was thrown. This indicates problems with program logic.";
            }
            case 2: {
                return "CallException was thrown. This indicates problems with calls to/from parent server.";
            }
            case 3: {
                return "ProtocolException was thrown. This indicates problems with executable versions between local and parent servers.";
            }
            case 4: {
                return "NoSuchElementException was thrown. This indicates problems with program logic.";
            }
            case 5: {
                return "IllegalArgumentException was thrown. This indicates problems with program logic.";
            }
            case 6: {
                return "IllegalResourceException was thrown. This indicates problems with server data.";
            }
            case 7: {
                return "IllegalClusterException was thrown. This indicates problems with server data.";
            }
            case 8: {
                return "ParseException was thrown. This indicates problems with/during parsing of the configuration file.";
            }
            case 9: {
                return "PortSemaphoreException was thrown. This indicates that some other server is using the same port number.";
            }
            case 10: {
                return "DatabaseSemaphoreException was thrown. This indicates that some other server is using the same database id.";
            }
            case 11: {
                return "SystemException was thrown. This indicates problems with program logic.";
            }
            case 12: {
                return "CppException was thrown. This indicates problems with program logic.";
            }
            case 13: {
                return "UnknownException was thrown. This indicates problems with program logic.";
            }
            case 14: {
                return "ThrowException was thrown. This indicates problems with program logic.";
            }
            case 15: {
                return "AssertException was thrown. This indicates problems with program logic.";
            }
            case 16: {
                return "ParentCheckException was thrown. This indicates problems with the database version of parent.";
            }
            case 17: {
                return "ParentConnectionException was thrown. This indicates problems with parent child relationship.";
            }
            case 18: {
                return "ConnectionException was thrown. This indicates problems with TCP/IP connections.";
            }
            case 19: {
                return "ProxyException was thrown. This indicates problems with TCP/IP connections to proxy.";
            }
            case 20: {
                return "NoSuchFileException was thrown. This indicates problems with a missing file.";
            }
            case 21: {
                return "JournalException was thrown. This indicates problems with journal mechanisim.";
            }
            case 22: {
                return "OutOfSpaceException was thrown. This indicates problems with memory.";
            }
            case 23: {
                return "ExternalValueException was thrown. This indicates problems with large value handling.";
            }
            case 24: {
                return "IllegalTransactionException was thrown. This indicates problems with transaction logic.";
            }
            case 25: {
                return "WriteTransactionException was thrown. This indicates that server failed during write transaction.";
            }
            case 26: {
                return "ConsoleException was thrown. This indicates that server console was closed without quit command.";
            }
            case 27: {
                return "ExitException was thrown. This indicates that server did not exit cleanly.";
            }
            case 28: {
                return "ExitReadPIdException was thrown. This indicates that server did not exit cleanly.";
            }
            case 29: {
                return "ExitReadStatusException was thrown. This indicates that server could not read exit status from guard file.";
            }
            case 30: {
                return "ExitStatusValueException was thrown. This indicates that server did not exit cleanly.";
            }
            case 31: {
                return "UpdateException was thrown. This indicates that server failed during update.";
            }
            case 32: {
                return "DatabaseVersionException was thrown. This indicates that server can not use given database.";
            }
            case 33: {
                return "DatabaseCorruptionException was thrown. This indicates that server has detected database corruption.";
            }
            case 34: {
                return "ExitReadPortException was thrown. This indicates that server did not start or exit cleanly.";
            }
            case 35: {
                return "ExitGuardOpenException was thrown. This indicates that server could not open guard file.";
            }
            case 36: {
                return "ExitGuardOpenWriteException was thrown. This indicates that server could not open guard file for writing.";
            }
            case 37: {
                return "ExitGuardWritePidException was thrown. This indicates that server could not write pid to guard file.";
            }
            case 38: {
                return "ExitGuardWritePortException was thrown. This indicates that server could not write port to guard file.";
            }
            case 39: {
                return "LastCommitNotCleanException was thrown. This indicates that client died during transaction. Recovery action needed.";
            }
            case 40: {
                return "TerminatedException was thrown. This indicates that server died because it received terminating signal.";
            }
            case 41: {
                return "ExitGuardWriteStatusException was thrown. This indicates that server could not write exit status to guard file.";
            }
            case 42: {
                return "EndReadStatusException was thrown. This indicates that server died because it could not read end status from guard file.";
            }
            case 43: {
                return "EndStatusValueException was thrown. This indicates that server died because end value was not zero.";
            }
            case 44: {
                return "ExitGuardReadVersionException was thrown. This indicates that server died because server could not read version from guard file.";
            }
            case 45: {
                return "ExitGuardValueVersionException was thrown. This indicates that server died because server did not support guard file version.";
            }
            case 46: {
                return "ExitGuardWriteVersionException was thrown. This indicates that server died because server could not write version to guard file.";
            }
            case 47: {
                return "ListenPortException was thrown. This indicates that server died because server could not listen to given port or any other port.";
            }
            case 48: {
                return "JournalVersionException was thrown. This indicates that database was written by older version.";
            }
            case 49: 
        }
        return "TailFileException was thrown. This indicates problems with handling of data involved with purge operation.";
    }

    synchronized void start() throws ProCoreException {
        block5: {
            try {
                this.startInternal();
            }
            catch (DatabaseLastExitException e) {
                throw e;
            }
            catch (Throwable t) {
                ProCoreException pe = null;
                if (t instanceof ProCoreException) {
                    pe = (ProCoreException)((Object)t);
                } else {
                    String msg = "ProCoreServer startup failed. Automatic rcovery handling not implemented. Database must be fixed manually.";
                    pe = new ProCoreException(msg, t);
                }
                if (pe.getDbFolder() != null) break block5;
                pe.setDbFolder(this.proCoreProcess.builder.directory());
            }
        }
    }

    synchronized void stop() throws ProCoreException, InterruptedException {
        boolean dead;
        if (this.databaseId != null) {
            databaseIds.remove(this.databaseId);
        }
        if (!(dead = this.tryToStop())) {
            throw new ProCoreException("Failed to stop ProCoreServer.");
        }
    }

    public synchronized String getExitMessage() throws ProCoreException {
        Integer returnValue = this.guardFile.getExitValue();
        if (returnValue == null) {
            throw new ProCoreException("Exit message not available.");
        }
        return this.getExitMessage(returnValue);
    }

    public synchronized ServerAddress getAddress() throws ProCoreException {
        return new ServerAddress(LOCALHOST, this.getPort());
    }

    public synchronized int getPort() throws ProCoreException {
        int port = 0;
        if (this.proCoreClient.isConnected() && (port = this.proCoreClient.getPort()) != 0) {
            return port;
        }
        if (this.proCoreProcess.isActive() && (port = this.proCoreProcess.getPort()) != 0) {
            return port;
        }
        return this.guardFile.getPort();
    }

    public synchronized TailFile.Data getTailData() throws ProCoreException {
        Path tailFolder = this.proCoreProcess.builder.directory().toPath().resolve(TAIL_DIR);
        return TailFile.readTailFile(tailFolder.resolve(TAIL_FILE).toFile());
    }

    public static class GuardFile {
        public static final String GUARD_FILE = "procore.guard.procore";
        private static final int VERSION_LINE = 1;
        private static final int PID_LINE = 2;
        private static final int PORT_LINE = 3;
        private static final int EXIT_LINE = 4;
        private static final int END_LINE = 5;
        private final File guardFile;

        GuardFile(File workingDir) {
            this.guardFile = new File(workingDir, "procore.guard.procore");
        }

        int getPort() throws ProCoreException {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            if (lines.length < 3) {
                throw new ProCoreException("Server port is not available. " + this.guardFile.getAbsolutePath());
            }
            return ProCoreServer.parseInt(lines[2]);
        }

        private void checkVersion(String[] lines) throws ProCoreException {
            if (lines.length < 1) {
                throw new ProCoreException("Guard file version is not available. " + this.guardFile.getAbsolutePath());
            }
            int version = ProCoreServer.parseInt(lines[0]);
            if (1 != version) {
                throw new GuardFileVersionException(this.guardFile, "Unsupported guard file version. version=" + version);
            }
        }

        boolean delete() {
            if (this.guardFile.exists()) {
                return this.guardFile.delete();
            }
            return true;
        }

        void deleteLog() {
            if (!this.guardFile.exists()) {
                return;
            }
            try {
                Files.delete(this.guardFile.toPath());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        Integer getExitValue() {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            try {
                this.checkVersion(lines);
                if (lines.length >= 4) {
                    return ProCoreServer.parseInt(lines[3]);
                }
                if (lines.length >= 2 && !ProCoreServer.isRunning(lines[1])) {
                    return -1;
                }
                return null;
            }
            catch (Exception e) {
                Logger.defaultLogError((String)"Could not get ProCoreServer exit value.", (Throwable)e);
                return null;
            }
        }

        boolean isActive(ProCoreClient proCoreClient) throws ProCoreException {
            block10: {
                if (proCoreClient.isConnected()) {
                    throw new ProCoreException("Illegal argument. ProCoreClient must not be connected.");
                }
                String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
                if (lines.length != 3) {
                    return false;
                }
                this.checkVersion(lines);
                int port = ProCoreServer.parseInt(lines[2]);
                if (port <= 0) break block10;
                try {
                    SessionAddress sa = new SessionAddress(new InetSocketAddress(ProCoreServer.LOCALHOST, port), true);
                    proCoreClient.connect(sa);
                    proCoreClient.execute("");
                }
                catch (ProCoreException proCoreException) {
                    try {
                        try {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            proCoreClient.disconnect();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                proCoreClient.disconnect();
                return true;
            }
            return false;
        }

        boolean isAlive() throws ProCoreException {
            String[] lines = ProCoreServer.getFileLines(this.guardFile, 5);
            if (lines.length < 1) {
                return false;
            }
            this.checkVersion(lines);
            if (lines.length < 2) {
                return false;
            }
            if (lines.length >= 5) {
                return false;
            }
            if (lines.length >= 4) {
                return false;
            }
            return ProCoreServer.isRunning(lines[1]);
        }
    }

    private static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType UNIX = new OSType();
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new OSType[]{UNIX, WINDOWS, UNKNOWN};
        }

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert (osName != null);
            if ((osName = osName.toLowerCase()).startsWith("windows")) {
                return WINDOWS;
            }
            if (osName.startsWith("mac os x") || osName.startsWith("linux") || osName.startsWith("sun")) {
                return UNIX;
            }
            return UNKNOWN;
        }

        public static OSType[] values() {
            OSType[] oSTypeArray = ENUM$VALUES;
            int n = oSTypeArray.length;
            OSType[] oSTypeArray2 = new OSType[n];
            System.arraycopy(ENUM$VALUES, 0, oSTypeArray2, 0, n);
            return oSTypeArray2;
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }

    static class ProCoreProcess {
        private static int instanceCount;
        private final ProcessBuilder builder;
        private final Manager manager;
        private Thread thread;

        ProCoreProcess(File exeFile, File workingDir) {
            String[] args = new String[]{};
            String[] cmd = new String[1 + args.length];
            cmd[0] = exeFile.getAbsolutePath().toString();
            System.arraycopy(args, 0, cmd, 1, args.length);
            this.builder = new ProcessBuilder(cmd);
            this.builder.redirectErrorStream(true);
            this.builder.directory(workingDir);
            this.manager = new Manager(workingDir);
            this.thread = new Thread((Runnable)this.manager, this.manager.initAndGetName());
        }

        public void tryToStart() throws ProCoreException, InterruptedException {
            this.manager.tryToStart();
        }

        public boolean isActive() throws ProCoreException {
            return this.manager.isActive();
        }

        public boolean tryToStop() throws ProCoreException {
            return this.manager.tryToStop();
        }

        int getPort() throws ProCoreException {
            return this.manager.getPort();
        }

        class Manager
        implements Runnable {
            private State state = State.Created;
            private CountDownLatch serverPrompted;
            private LinkedBlockingQueue<String> reply;
            private volatile String command;
            private volatile Integer exitValue;
            private volatile boolean carryOn;
            private volatile int port;
            private final File dbFolder;

            Manager(File dbFolder) {
                this.dbFolder = dbFolder;
                this.init();
            }

            private void init() {
                this.serverPrompted = new CountDownLatch(1);
                this.reply = new LinkedBlockingQueue();
                this.exitValue = null;
                this.carryOn = true;
                this.port = 0;
                this.state = State.Initialized;
            }

            int getPort() {
                return this.port;
            }

            void tryToStart() throws ProCoreException, InterruptedException {
                if (ProCoreProcess.this.thread.isAlive()) {
                    return;
                }
                ProCoreProcess.this.thread = new Thread((Runnable)ProCoreProcess.this.manager, ProCoreProcess.this.manager.initAndGetName());
                ProCoreProcess.this.thread.start();
                this.serverPrompted.await();
                if (!this.state.equals((Object)State.Prompted)) {
                    throw new DatabaseLastExitException(this.dbFolder, "Server did not prompt.");
                }
                String reply = this.giveCommand("print port");
                try {
                    this.port = Integer.parseInt(reply);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.exitValue != null && this.exitValue != 0) {
                        throw new DatabaseLastExitException(this.dbFolder, "Server did not prompt.");
                    }
                    if (reply.equals("End of server thread.")) {
                        throw new ProCoreException("Server did not start (did not prompt). state=" + (Object)((Object)this.state));
                    }
                    throw new ProCoreException("Server did not start. Could not parse port. reply=" + reply);
                }
                this.state = State.GotPort;
            }

            String giveCommand(String command) throws ProCoreException, InterruptedException {
                if (!ProCoreProcess.this.thread.isAlive()) {
                    throw new ProCoreException("Server thread not alive.");
                }
                if (this.command != null) {
                    throw new ProCoreException("Old command pending.");
                }
                this.command = command;
                return this.reply.take();
            }

            private String initAndGetName() {
                this.init();
                return "ProCoreProcess " + ++instanceCount + " " + ProCoreProcess.this.builder.directory();
            }

            boolean isActive() throws ProCoreException {
                return this.exitValue == null && ProCoreProcess.this.thread.isAlive();
            }

            boolean tryToStop() throws ProCoreException {
                if (!ProCoreProcess.this.thread.isAlive()) {
                    return true;
                }
                this.carryOn = false;
                ProCoreProcess.this.thread.interrupt();
                try {
                    ProCoreProcess.this.thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {}
                return !ProCoreProcess.this.thread.isAlive();
            }

            @Override
            public void run() {
                block6: {
                    this.state = State.ThreadStarted;
                    Util.log("ProCoreServer thread started.");
                    try {
                        try {
                            Util.trace("ProCoreProcessManager start.");
                            Process process = ProCoreProcess.this.builder.start();
                            this.exitValue = this.exitValue(process);
                            if (this.exitValue != null) {
                                Util.logError("Server process did not start.");
                                break block6;
                            }
                            this.state = State.ProcessStarted;
                            this.runProcessStarted(process);
                        }
                        catch (IOException iOException) {
                            Util.logError("Failed during process watch.");
                            this.reply.add("End of server thread.");
                            Util.trace("ProCoreServerThread stop.");
                            this.state = State.ThreadStopped;
                            this.serverPrompted.countDown();
                        }
                    }
                    finally {
                        this.reply.add("End of server thread.");
                        Util.trace("ProCoreServerThread stop.");
                        this.state = State.ThreadStopped;
                        this.serverPrompted.countDown();
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void runProcessStarted(Process process) throws IOException {
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
                            do {
                                try {
                                    if (reader.ready()) {
                                        this.handleLine(reader.readLine(), reader, writer);
                                    } else if (this.command != null) {
                                        writer.write(this.command);
                                        this.command = null;
                                        writer.newLine();
                                        writer.flush();
                                        String line = this.getReply(reader);
                                        this.reply.add(line);
                                    } else {
                                        Thread.sleep(100L);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    Util.trace("ProCoreServerThread interrupted.");
                                }
                                this.exitValue = this.exitValue(process);
                                if (this.exitValue != null || this.carryOn) continue;
                                try {
                                    try {
                                        writer.write(ProCoreServer.QUIT_CMD);
                                        writer.newLine();
                                        writer.flush();
                                    }
                                    catch (Throwable t) {
                                        Util.logError("Wait for process death was interrupted.", t);
                                    }
                                    this.exitValue = process.waitFor();
                                }
                                catch (InterruptedException e) {
                                    Util.logError("Wait for process death was interrupted.", e);
                                    this.carryOn = true;
                                }
                            } while (this.exitValue == null);
                        }
                        if (reader == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }

            private String getReply(BufferedReader reader) throws IOException {
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null && !line.startsWith("Waiting for input?")) {
                    sb.append(line);
                }
                return sb.toString();
            }

            private void handleLine(String line, BufferedReader reader, BufferedWriter writer) throws IOException {
                if (line.startsWith("Main end.")) {
                    this.carryOn = false;
                } else if (this.serverPrompted.getCount() > 0L && line.startsWith("Waiting for input?")) {
                    this.state = State.Prompted;
                    this.serverPrompted.countDown();
                } else {
                    Util.trace("From server. line=" + line);
                }
            }

            private Integer exitValue(Process process) {
                try {
                    return process.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    return null;
                }
            }
        }

        private static enum State {
            Created,
            Initialized,
            ThreadStarted,
            ProcessStarted,
            Prompted,
            GotPort,
            ThreadStopped;

        }
    }

    public static class TailFile {
        public static void createTailFile(File file, long nextChangeSetId, long nextFreeId, String dbId) throws ProCoreException {
            FileOutputStream fos;
            if (file.exists()) {
                throw new TailException("Tail file exists and thus cannot be created. file=" + file);
            }
            try {
                fos = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TailException("Tail file cannot be created. file=" + file);
            }
            try (PrintStream ps = new PrintStream(fos);){
                ps.println(1);
                ps.println(nextChangeSetId);
                ps.println(nextFreeId);
                ps.println(dbId);
            }
        }

        public static Data readTailFile(File file) throws ProCoreException {
            String[] lines = ProCoreServer.getFileLines(file, 3);
            if (lines.length < 3) {
                throw new TailReadException("Could not read data from " + file);
            }
            long ver = Long.parseLong(lines[0]);
            long cs = Long.parseLong(lines[1]);
            long id = Long.parseLong(lines[2]);
            return new Data(ver, cs, id);
        }

        public static class Data {
            long version;
            public long nextChangeSetId;
            long nextFreeId;

            Data(long version, long nextChangeSetId, long nextFreeId) {
                this.version = version;
                this.nextChangeSetId = nextChangeSetId;
                this.nextFreeId = nextFreeId;
            }
        }
    }
}

