/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.DatabaseI;

public class DatabaseManager {
    private static Map<String, DatabaseI> dbs = new HashMap<String, DatabaseI>();

    public static DatabaseI getDatabase(Path folder) throws ProCoreException {
        String address;
        try {
            address = folder.toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new ProCoreException("Could not get canonical path.", e);
        }
        DatabaseI db = dbs.get(address);
        if (db != null) {
            return db;
        }
        db = DatabaseI.newDatabaseI(folder.toFile());
        dbs.put(address, db);
        return db;
    }
}

