/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class GetClusterChangesFunction extends AbstractFunction {
    public long changeSetId = 0;
    public byte[] clusterUID = null;
    public long headChangeSetId = 0;
    public int[] resourceIndex = null;
    public int[] predicateIndex = null;
    public long[] predicateFirst = null;
    public long[] predicateSecond = null;
    public int[] valueIndex = null;
    public GetClusterChangesFunction() {
        super(MessageNumber.GetClusterChangesRequest, MessageNumber.GetClusterChangesResponse);
    }
    public GetClusterChangesFunction(long changeSetId, byte[] clusterUID) {
        super(MessageNumber.GetClusterChangesRequest, MessageNumber.GetClusterChangesResponse);
        this.changeSetId = changeSetId;
        this.clusterUID = clusterUID;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(changeSetId);
        buffer.put(clusterUID);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        headChangeSetId = dataBuffer.get(headChangeSetId);
        resourceIndex = dataBuffer.get(resourceIndex);
        predicateIndex = dataBuffer.get(predicateIndex);
        predicateFirst = dataBuffer.get(predicateFirst);
        predicateSecond = dataBuffer.get(predicateSecond);
        valueIndex = dataBuffer.get(valueIndex);
        gotResponse();
    }
}
