package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.service.SessionUserSupport;

public class SessionUserSupportImpl implements SessionUserSupport {
	
	final private SessionImplSocket session;
	
	SessionUserSupportImpl(SessionImplSocket session) {
		this.session = session;
	}
    
    @Override
    final public Resource getUser() {
        if (session.user == null) {
        	int id = session.builtinSupport.getBuiltin("http://Users/DefaultUser");
        	if (id==0) {
                System.err.println("Warning: http://Users/DefaultUser built-in was not found.");
        	    return null;
        	}
            return session.getResource(id);
        } else {
            return session.user;
        }
    }

    @Override
    final public String getUserName() {
        return session.authenticator.userName();
    }

    @Override
    final public String getUserRemoteDigest() {
        return session.authenticator.remoteDigest();
    }
    
}
