package fi.vtt.simantics.procore.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.Disposable;
import org.simantics.db.service.ClusterSets;
import org.simantics.db.service.ClusterSetsSupport;

public class ClusterSetsSupportImpl implements ClusterSetsSupport, Disposable {
    
    final private static boolean DEBUG = false;
    final private static Map<String, ClusterSets> sClusterSets = new HashMap<String, ClusterSets>();
    final private File filePath;
    private String databaseId; // Unique identifier for database of session. Initialized in connect. 
    private ClusterSets clusterSets; // Cluster sets for session. Initialized in connect.
    ClusterSetsSupportImpl(File filePath) {
        this.filePath = filePath;
        this.databaseId = null;
        this.clusterSets = null;
    }
    public synchronized void connect(String databaseId) {
        assert(null == this.databaseId);
        this.databaseId = databaseId;
        clusterSets = sClusterSets.get(databaseId);
        int count = 1;
        if (null == clusterSets) {
            clusterSets = new ClusterSets(filePath, filePath, databaseId);
            sClusterSets.put(databaseId, clusterSets);
        } else {
            count = clusterSets.inc();
        }
        if (DEBUG)
            System.out.println("Starting session " + count + " for database=" + databaseId);
    }
    @Override
    public synchronized void dispose() {
        if (clusterSets == null)
            return;
        clusterSets.dispose();
        if (0 >= clusterSets.dec()) {
            sClusterSets.remove(databaseId);
            if (DEBUG)
                System.out.println("Stopping session for database=" + databaseId);
        }            
        clusterSets = null;
    }
    public synchronized boolean containsKey(long resourceId) {
        return clusterSets.containsKey(resourceId);
    }
    public synchronized Long get(Long resourceId) {
        return clusterSets.get(resourceId);
    }
    public synchronized void put(long resourceId, long clusterId) {
        clusterSets.put(resourceId, clusterId);
    }
    public synchronized void save()
    throws IOException {
        clusterSets.save();
    }
    
    public synchronized Long getSet(long clusterId) {
        return clusterSets.getClusterSet(clusterId);
    }
    @Override
    public void clear() {
    	clusterSets.clear();
    }
    
    @Override
    public void updateWriteDirectory(Path write) {
        // Nothing to do here
    }
    
    @Override
    public void setReadDirectory(Path read) {
        
    }
    
}
