/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore;
import java.io.IOException;
import java.util.Properties;

import org.simantics.db.SessionManager;
import org.simantics.db.procore.protocol.Constants;

import fi.vtt.simantics.procore.internal.SessionManagerFactory;
import fi.vtt.simantics.procore.internal.SessionManagerFactoryImpl;

public final class SessionManagerSource {
    
	public static final long      NullSessionId         = Constants.NullSessionId;
    public static final long      NullTransactionId     = Constants.NullTransactionId;
    public static final long      NullSubjectId         = Constants.NullSubjectId;
	
	private static SessionManager defaultSessionManager = null;
	
    /**
     * @param loggerProperties
     * @return
     * @throws IOException
     */
    public static synchronized SessionManager getSessionManager(Properties loggerProperties) throws IOException {
        if (defaultSessionManager == null) {
            SessionManagerFactory factory = SessionManagerFactoryImpl.getInstance();
            defaultSessionManager = factory.createSessionManager();
        }
        return defaultSessionManager;
    }

    /**
     * @return
     * @throws IOException
     */
    public static synchronized SessionManager getSessionManager() throws IOException {
        return getSessionManager(nullProperties);
    }

    /**
     * 
     */
    public static synchronized void shutdown() {
        SessionManagerFactoryImpl.finish();
    }

    
    /**
     * Properties with the default null logger settings.
     */
    public static Properties nullProperties = new Properties();
    static {
        nullProperties.put("log4j.rootCategory", "INFO, default");
        nullProperties.put("log4j.appender.default", "org.apache.log4j.varia.NullAppender");
    }
    
}
