package org.simantics.db.layer0.util;

import java.io.IOException;
import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.ByteBufferReadable;
import org.simantics.db.ReadGraph;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TGTransferableGraphSource implements TransferableGraphSource {

	final private TransferableGraph1 tg;
	
	public TGTransferableGraphSource(TransferableGraph1 tg) {
		this.tg = tg;
	}

	@Override
	public DataContainer getHeader() throws Exception {
	    return null;
	}
	
	@Override
	public int getResourceCount() {
		return tg.resourceCount;
	}
	
	@Override
	public int getIdentityCount() {
		return tg.identities.length;
	}
	
	@Override
	public int getStatementCount() {
		return tg.statements.length;
	}
	
	@Override
	public int getValueCount() {
		return tg.values.length;
	}

	@Override
	public void forStatements(ReadGraph graph, TransferableGraphSourceProcedure<int[]> procedure) throws Exception {
		int[] value = new int[4];
		for(int i=0;i<tg.statements.length;i+=4) {
			value[0] = tg.statements[i];
			value[1] = tg.statements[i+1];
			value[2] = tg.statements[i+2];
			value[3] = tg.statements[i+3];
			procedure.execute(value);
		}
	}

	@Override
	public void forIdentities(ReadGraph graph, TransferableGraphSourceProcedure<Identity> procedure) throws Exception {
		for(int i=0;i<tg.identities.length;i++) {
			procedure.execute(tg.identities[i]);
		}
	}

	@Override
	public void forValues(ReadGraph graph, TransferableGraphSourceProcedure<Value> procedure) throws Exception {
		for(int i=0;i<tg.values.length;i++) {
			procedure.execute(tg.values[i]);
		}
	}

    @Override
    public void forValues2(ReadGraph graph, TransferableGraphSourceValueProcedure procedure) throws Exception {
        for(int i=0;i<tg.values.length;i++) {
            Value value = tg.values[i];
            Binding binding = value.value.getBinding();
            Datatype dt = binding.type();
            Serializer s = Bindings.getSerializer(binding);
            procedure.execute(value.resource, dt, new ByteBufferReadable(s.serialize(value.value.getValue(binding))));
        }
    }
	
	@Override
	public TreeMap<String, Variant> getExtensions() {
		return tg.extensions;
	}
    
    @Override
    public void reset() {
    }

    @Override
    public void close() {
    }

}
