/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class DataValues {

	public static Resource createLiteral(WriteGraph g, Object value, Binding binding) throws DatabaseException {
		Layer0 l0 = Layer0.getInstance(g);
		Resource literal = g.newResource();
		g.claim(literal, l0.InstanceOf, l0.Literal);
		Resource dataType = g.newResource();
		g.claim(dataType, l0.InstanceOf, l0.DataType);
		g.claimValue(dataType, binding.type(), 
				Bindings.getBindingUnchecked(Datatype.class));
		g.claim(literal, l0.HasDataType, dataType);
		g.claimValue(literal, value, binding);
		return literal;
	}
		
}
