package org.simantics.db.layer0.request.external;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Triple;

/**
 * @author Tuukka Lehtonen
 * @since 1.52.0
 */
public class EclipsePreferenceBooleanPrimitiveRead extends ParametrizedPrimitiveRead<Triple<String,String,Boolean>,Boolean> implements IPreferenceChangeListener {

    private Listener<Boolean> listener;

    public EclipsePreferenceBooleanPrimitiveRead(String plugin, String key, boolean def) {
        super(Triple.make(plugin, key, def));
    }

    @Override
    public void register(ReadGraph graph, Listener<Boolean> procedure) {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (!procedure.isDisposed() && preferenceNode != null) {
            preferenceNode.addPreferenceChangeListener(this);
        }
        listener = procedure;
        Boolean value = preferenceNode != null ? preferenceNode.getBoolean(parameter.second, parameter.third) : parameter.third;
        procedure.execute(value);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        if (parameter.second.equals(event.getKey())) {
            IEclipsePreferences preferenceNode = resolvePreferenceNode();
            Boolean value = preferenceNode != null ? preferenceNode.getBoolean(parameter.second, parameter.third) : parameter.third;
            listener.execute(value);
        }
    }

    @Override
    public void unregistered() {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (preferenceNode != null) {
            preferenceNode.removePreferenceChangeListener(this);
        }
        listener = null;
    }

    private IEclipsePreferences resolvePreferenceNode() {
        IEclipsePreferences preferenceNode = InstanceScope.INSTANCE.getNode( parameter.first );
        return preferenceNode;
    }

}
