package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.SessionModel;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.operation.Layer0X;

public class PossibleSessionUser implements Read<Resource> {

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance(graph);
        Resource session = graph.getService(SessionModel.class).getResource();
        return graph.getPossibleObject(session, L0X.Session_HasUser);
    }
    
}