/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation.combinators;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;

/**
 * Takes the complement of a relation;
 */
public class Complement extends AbstractRelation {

	GenericRelation base;
	
	public Complement(GenericRelation base) {
		this.base = base;
	}

	@Override
	public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
		return !base.contains(g, tuple);
	}
	
	@Override
	public GenericRelation select(String bindingPattern, Object[] constants) {
		return new Complement(base.select(bindingPattern, constants));
	}

	@Override
	public Pair<String, String>[] getFields() {
		return base.getFields();
	}

}
