package org.simantics.db.layer0.function;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMapImpl;

import gnu.trove.set.hash.THashSet;

public class StandardChildDomainChildren extends VariableMapImpl {

	@Override
	public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
		return getStandardChildDomainChildVariable(graph, context, name);
	}

	@Override
	public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
	    return getStandardChildDomainChildVariables(graph, context, map);
	}

    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        Resource graphChild = All.getPossibleGraphChild(graph, context, name);
        return getStandardChildDomainChildVariable(graph, context, graphChild, name);
    }

    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, Resource graphChild, String name) throws DatabaseException {
    	AbstractVariable variable = (AbstractVariable)context;
        Object childNode = All.getPossibleNodeChild(graph, variable, name);
        if(graphChild != null)
        	return All.buildChildVariable(graph, context, graphChild, childNode);
        if(childNode != null)
        	return All.createStandardGraphChildVariable(variable, childNode);
        return null;
    }
    
    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        Map<String,Resource> graphChildren = All.getPossibleGraphChildren(graph, context);
        return StandardChildDomainChildren.getStandardChildDomainChildVariables(graph, context, graphChildren, map);
    }

    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String,Resource> graphChildren, Map<String, Variable> map) throws DatabaseException {
	    
    	AbstractVariable variable = (AbstractVariable)context;
        
        Collection<Object> nodeChildren = All.getPossibleNodeChildren(graph, variable);
        
        if(graphChildren.isEmpty() && nodeChildren.isEmpty()) return map;
        
        Set<String> used = new THashSet<String>(nodeChildren.size());

        map = All.ensureVariableMap(map, graphChildren.size());

        for(Object nodeChild : nodeChildren) {
            String name = All.getNodeName(variable, nodeChild);
            used.add(name);
            Resource graphChild = graphChildren.get(name); 
            if(graphChild != null){
            	Variable var = All.buildChildVariable(graph, context, graphChild, nodeChild);
                if(var != null) {
                    map.put(name, var);
                    continue;
                }
            }
            map.put(name, All.createStandardGraphChildVariable(variable, nodeChild));
        }
        
        for(Map.Entry<String, Resource> entry : graphChildren.entrySet()) {
            String name = entry.getKey();
            if(used.contains(name)) continue;
            Resource child = entry.getValue();
            Variable var = All.buildChildVariable(graph, context, child, null);
            if(var != null) map.put(name, var);
        }
        
        return map;
        
    }
    
}
