/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.IndexedRelationsMemorySearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.indexing.exception.IndexingException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedRelationsSearcher
extends IndexedRelationsSearcherBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexedRelationsSearcher.class);
    IndexedRelationsMemorySearcher cache;

    IndexedRelationsSearcher(RequestProcessor session, Resource relation, Resource input, GenericRelation r) throws DatabaseException {
        super(session, relation, input);
        this.cache = new IndexedRelationsMemorySearcher(session, this, relation, input, r);
    }

    @Override
    String getDescriptor() {
        return "DISK: ";
    }

    @Override
    public void setProblem(Throwable t) {
        super.setProblem(t);
        this.cache.setProblem(t);
    }

    @Override
    boolean startAccess(IProgressMonitor monitor, Session session, boolean forWriting) {
        boolean success = super.startAccess(monitor, session, false);
        if (!success) {
            return false;
        }
        success = this.cache.startAccess(monitor, session, forWriting);
        if (!success) {
            this.setProblem(this.cache.getException());
            return false;
        }
        return true;
    }

    @Override
    void insertIndex(IProgressMonitor monitor, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (Object[] data : documentsData) {
            keyValues.add(data[1]);
        }
        this.cache.replaceIndex(monitor, "Resource", keyValues, r, boundLength, documentsData);
    }

    @Override
    void removeIndex(IProgressMonitor monitor) throws DatabaseException, CorruptIndexException, IOException {
        super.removeIndex(monitor);
        this.cache.removeIndex(monitor);
    }

    @Override
    void removeIndex(IProgressMonitor monitor, GenericRelation r, RequestProcessor processor, String key, Collection<Object> keyValues) throws DatabaseException, CorruptIndexException, IOException {
        ArrayList<Object[]> documentsData = new ArrayList<Object[]>();
        Pair[] fields = r.getFields();
        for (Object keyValue : keyValues) {
            Object[] data = new Object[fields.length - 1];
            int index = 0;
            int i = 1;
            while (i < fields.length) {
                String fieldName = (String)fields[i].first;
                if (key.equals(fieldName)) {
                    data[index++] = keyValue;
                } else {
                    String fieldClass = (String)fields[i].second;
                    if ("Long".equals(fieldClass)) {
                        data[index++] = 0L;
                    } else if ("String".equals(fieldClass) || "Text".equals(fieldClass)) {
                        data[index++] = "";
                    } else {
                        throw new IndexingException("Can only index Long and String fields, encountered class " + fieldClass);
                    }
                }
                ++i;
            }
            documentsData.add(data);
        }
        this.cache.replaceIndex(monitor, key, keyValues, r, 1, documentsData);
    }

    @Override
    boolean replaceIndex(IProgressMonitor monitor, String key, Collection<Object> keyValues, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        boolean result = this.cache.replaceIndex(monitor, key, keyValues, r, boundLength, documentsData);
        return result;
    }

    List<Map<String, Object>> persistentCachedSearch(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        List<Map<String, Object>> result;
        MemoryIndexing mem = MemoryIndexing.getInstance(this.session.getSession());
        String key = this.indexPath.toAbsolutePath().toString();
        Map<String, List<Map<String, Object>>> cache = mem.persistentCache.get(key);
        if (cache != null && (result = cache.get(search)) != null) {
            return result;
        }
        this.startAccess(monitor, processor.getSession(), false);
        List<Map<String, Object>> results = super.doSearch(monitor, processor, search, maxResultCount);
        if (cache == null) {
            cache = new HashMap<String, List<Map<String, Object>>>();
            mem.persistentCache.put(key, cache);
        }
        if (results.size() < 500) {
            cache.put(search, results);
        }
        return results;
    }

    List<Resource> persistentCachedSearchResources(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        List<Resource> result;
        MemoryIndexing mem = MemoryIndexing.getInstance(this.session.getSession());
        String key = this.indexPath.toAbsolutePath().toString();
        Map<String, List<Resource>> cache = mem.persistentCacheResources.get(key);
        if (cache != null && (result = cache.get(search)) != null) {
            return result;
        }
        this.startAccess(monitor, processor.getSession(), false);
        List<Resource> results = super.doSearchResources(monitor, processor, search, maxResultCount);
        if (cache == null) {
            cache = new HashMap<String, List<Resource>>();
            mem.persistentCacheResources.put(key, cache);
        }
        if (results.size() < 500) {
            cache.put(search, results);
        }
        return results;
    }

    List<Object> persistentCachedList(IProgressMonitor monitor, RequestProcessor processor) throws ParseException, IOException, IndexingException {
        this.startAccess(monitor, processor.getSession(), false);
        List<Object> results = super.doList(monitor, processor);
        return results;
    }

    @Override
    List<Map<String, Object>> doSearch(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        List<Map<String, Object>> persistent = this.persistentCachedSearch(monitor, processor, search, maxResultCount);
        List<Map<String, Object>> cached = this.cache.doSearch(monitor, processor, search, maxResultCount);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> m : persistent) {
            Resource r = (Resource)m.get("Resource");
            if (this.cache.changed.contains(r.getResourceId())) continue;
            result.add(m);
        }
        result.addAll(cached);
        return result;
    }

    @Override
    List<Resource> doSearchResources(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        List<Resource> persistent = this.persistentCachedSearchResources(monitor, processor, search, maxResultCount);
        List<Resource> cached = this.cache.doSearchResources(monitor, processor, search, maxResultCount);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : persistent) {
            if (this.cache.changed.contains(r.getResourceId())) continue;
            result.add(r);
        }
        result.addAll(cached);
        return result;
    }

    @Override
    List<Object> doList(IProgressMonitor monitor, RequestProcessor processor) throws ParseException, IOException, IndexingException {
        List<Object> persistent = this.persistentCachedList(monitor, processor);
        return persistent;
    }

    void applyChanges(IProgressMonitor monitor, Session session, GenericRelation r, Collection<Object[]> os) throws Exception {
        if (!os.isEmpty()) {
            ArrayList<Object> replaceKeys = new ArrayList<Object>();
            ArrayList<Object[]> replaceValues = new ArrayList<Object[]>();
            ArrayList<Object> removeKeys = new ArrayList<Object>();
            for (Object[] o : os) {
                Long parent = (Long)o[0];
                Long key = (Long)o[1];
                if (parent != 0L) {
                    replaceKeys.add(key);
                    replaceValues.add(o);
                    continue;
                }
                removeKeys.add(key);
            }
            this.changeState(monitor, session, IndexedRelationsSearcherBase.State.READY);
            super.startAccess(null, session, true);
            super.replaceIndex(null, "Resource", replaceKeys, r, 1, replaceValues);
            super.removeIndex(null, r, null, "Resource", removeKeys);
        }
        this.changeState(monitor, session, IndexedRelationsSearcherBase.State.READY);
    }

    @Override
    Throwable bestEffortClear(IProgressMonitor monitor, Session session) {
        this.changeState(monitor, session, IndexedRelationsSearcherBase.State.NONE);
        Throwable t = this.clearDirectory(monitor, session);
        if (t != null) {
            return t;
        }
        t = this.cache.bestEffortClear(monitor, session);
        if (t != null) {
            return t;
        }
        String key = this.indexPath.toAbsolutePath().toString();
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        mem.persistentCache.remove(key);
        mem.persistentCacheResources.remove(key);
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

