package org.simantics.db.indexing;

import java.util.Collections;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

/**
 * A (cacheable) query to optimize single index queries for immutable
 * indexes such as ontologies.
 */
class QueryIndexResources extends BinaryRead<Resource, String, List<Resource>> {

	public QueryIndexResources(Resource index, String filter) {
		super(index, filter);
	}

	@Override
	public List<Resource> perform(ReadGraph graph) throws DatabaseException {

		Layer0X L0X = Layer0X.getInstance(graph);

		@SuppressWarnings({ "unchecked", "rawtypes" })
		Function dependencies = graph.syncRequest(new Adapter(L0X.DependencyResources, Function.class), TransientCacheListener.<Function>instance());

		@SuppressWarnings("unchecked")
		List<Resource> results = (List<Resource>)dependencies.apply(graph, parameter, parameter2);
		if (results == null || results.isEmpty())
			return Collections.emptyList();

		return results;

	}

}