/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;
import org.simantics.db.impl.query.UnaryQueryP;

public final class RelationInfoQuery
extends UnaryQueryP<RelationInfo> {
    RelationInfoQuery(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    private static void computeAssertions(ReadGraphImpl graph, final int r, final boolean isFinal, final boolean isFunctional, RelationInfoQuery parent, final InternalProcedure<RelationInfo> procedure) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        int isUsedInAssertion = processor.getHasPredicateInverse();
        assert (isUsedInAssertion != 0);
        QueryCache.runnerDirectObjects(graph, r, isUsedInAssertion, parent, null, new IntProcedure(){
            boolean done = false;

            @Override
            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                if (this.done) {
                    return;
                }
                this.done = true;
                RelationInfo result = new RelationInfo(r, isFunctional, isFinal, true);
                procedure.execute(graph, result);
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                if (this.done) {
                    return;
                }
                this.done = true;
                RelationInfo result = new RelationInfo(r, isFunctional, isFinal, false);
                procedure.execute(graph, result);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
                if (this.done) {
                    return;
                }
                this.done = true;
                DatabaseException e = new DatabaseException("Internal error in RelationInfoQuery");
                procedure.exception(graph, e);
            }
        });
    }

    public static void computeForEach(ReadGraphImpl graph, int r, RelationInfoQuery entry, InternalProcedure<RelationInfo> procedure_) throws DatabaseException {
        InternalProcedure<RelationInfo> procedure = entry != null ? entry : procedure_;
        QueryProcessor provider = graph.processor;
        int superRelationOf = provider.getSuperrelationOf();
        assert (superRelationOf != 0);
        IntSet direct = QueryCache.resultDirectPredicates(graph, r, entry, null);
        IntSet types = QueryCache.resultTypes(graph, r, entry, null);
        RelationInfoQuery.computeAssertions(graph, r, !direct.contains(superRelationOf), types.contains(graph.processor.getFunctionalRelation()), entry, procedure);
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<RelationInfo> procedure) throws DatabaseException {
        RelationInfoQuery.computeForEach(graph, this.id, this, procedure);
    }

    public String toString() {
        return "RelationInfoQuery[" + this.id + "]";
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public void serializeValue(QuerySerializer serializer) {
        RelationInfo ri = (RelationInfo)this.getResult();
        serializer.addResource(ri.predicate);
        serializer.add(ri.isFunctional ? (byte)1 : 0);
        serializer.add(ri.isFinal ? (byte)1 : 0);
        serializer.add(ri.isAsserted ? (byte)1 : 0);
    }
}

