/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.procedure.TLongIntProcedure;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;

public class QuerySerializer {
    private QueryProcessor processor;
    private QuerySupport querySupport;
    private TByteArrayList bytes = new TByteArrayList();
    private TLongIntHashMap clusterKeys = new TLongIntHashMap();
    private Map<String, Integer> ids = new HashMap<String, Integer>();

    public QuerySerializer(QueryProcessor processor) {
        this.processor = processor;
        this.querySupport = processor.querySupport;
    }

    public int writeUnknownSize() {
        int pos = this.bytes.size();
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        this.bytes.add((byte)0);
        return pos;
    }

    public void setUnknownSize(int pos, int value) {
        this.bytes.set(pos, (byte)(value & 0xFF));
        this.bytes.set(pos + 1, (byte)(value >>> 8 & 0xFF));
        this.bytes.set(pos + 2, (byte)(value >>> 16 & 0xFF));
        this.bytes.set(pos + 3, (byte)(value >>> 24 & 0xFF));
    }

    public void serializeId(String classId) {
        Integer id = this.ids.get(classId);
        if (id == null) {
            id = this.ids.size() + 1;
            this.ids.put(classId, id);
        }
        this.writeLE(id);
    }

    public void addResource(int r) {
        if (r < 0) {
            this.writeLE(r);
        } else {
            long clusterId = this.querySupport.getClusterId(r);
            int clusterKey = this.clusterKeys.get(clusterId);
            if (clusterKey == 0) {
                clusterKey = this.clusterKeys.size() + 1;
                this.clusterKeys.put(clusterId, clusterKey);
            }
            int i = ClusterTraitsBase.createResourceKeyNoThrow(clusterKey, ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(r));
            this.writeLE(i);
        }
    }

    public void addString(String s) {
        byte[] b = s.getBytes();
        this.writeLE(b.length);
        this.bytes.add(b);
    }

    public void add(byte b) {
        this.bytes.add(b);
    }

    public void add(byte[] bs) {
        this.bytes.add(bs);
    }

    public byte[] bytes() {
        final TByteArrayList header = new TByteArrayList();
        QuerySerializer.writeLE(header, this.ids.size());
        for (Map.Entry<String, Integer> entry : this.ids.entrySet()) {
            String id = entry.getKey();
            QuerySerializer.writeLE(header, id.length());
            header.add(id.getBytes());
            QuerySerializer.writeLE(header, entry.getValue());
        }
        QuerySerializer.writeLE(header, this.clusterKeys.size());
        this.clusterKeys.forEachEntry(new TLongIntProcedure(){

            public boolean execute(long a, int b) {
                QuerySerializer.writeLE(header, a);
                QuerySerializer.writeLE(header, b);
                return true;
            }
        });
        header.add(this.bytes.toArray());
        return header.toArray();
    }

    public void writeLE(int value) {
        QuerySerializer.writeLE(this.bytes, value);
    }

    public static void writeLE(TByteArrayList bytes, int value) {
        bytes.add((byte)(value & 0xFF));
        bytes.add((byte)(value >>> 8 & 0xFF));
        bytes.add((byte)(value >>> 16 & 0xFF));
        bytes.add((byte)(value >>> 24 & 0xFF));
    }

    public void writeLE(long value) {
        QuerySerializer.writeLE(this.bytes, value);
    }

    public static void writeLE(TByteArrayList bytes, long value) {
        bytes.add((byte)(value & 0xFFL));
        bytes.add((byte)(value >>> 8 & 0xFFL));
        bytes.add((byte)(value >>> 16 & 0xFFL));
        bytes.add((byte)(value >>> 24 & 0xFFL));
        bytes.add((byte)(value >>> 32 & 0xFFL));
        bytes.add((byte)(value >>> 40 & 0xFFL));
        bytes.add((byte)(value >>> 48 & 0xFFL));
        bytes.add((byte)(value >>> 56 & 0xFFL));
    }

    public QueryProcessor getQueryProcessor() {
        return this.processor;
    }
}

