/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QuerySerializer;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.UnaryQuery;

public abstract class CollectionUnaryQuery
extends UnaryQuery<IntProcedure>
implements IntProcedure {
    public CollectionUnaryQuery(int id) {
        super(id);
    }

    public abstract void compute(ReadGraphImpl var1, IntProcedure var2) throws DatabaseException;

    @Override
    public final void clearResult(QuerySupport support) {
        this.setResult(new IntArray());
    }

    @Override
    public final void setReady() {
        super.setReady();
        IntArray v = (IntArray)this.getResult();
        int size = v.size();
        if (size == 0) {
            this.setResult(IntArray.EMPTY);
        } else {
            v.trim();
        }
    }

    @Override
    public final Object performFromCache(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return this.getResult();
    }

    @Override
    public final void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }
        });
    }

    @Override
    final boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }

    @Override
    public final void execute(ReadGraphImpl graph, int i) throws DatabaseException {
        IntArray v = (IntArray)this.getResult();
        v.add(i);
    }

    @Override
    public final void finished(ReadGraphImpl graph) throws DatabaseException {
        this.setReady();
    }

    @Override
    public final void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        this.except(throwable);
    }

    @Override
    public void serializeValue(QuerySerializer serializer) {
        IntArray is = (IntArray)this.getResult();
        is.serialize(serializer);
    }
}

