/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

public class TableHeader {
    public static final int HEADER_SIZE = 4;
    public static final int EXTRA_SIZE = 4;
    private final int CAPACITY_INDEX;
    private final int SIZE_INDEX;
    private final int COUNT_INDEX;
    private final int OFFSET_INDEX;
    private final int EXTRA_INDEX;
    private int[] header;

    TableHeader(int[] header, int headerBase) {
        this.CAPACITY_INDEX = headerBase++;
        this.SIZE_INDEX = headerBase++;
        this.COUNT_INDEX = headerBase++;
        this.OFFSET_INDEX = headerBase++;
        this.EXTRA_INDEX = headerBase++;
        this.header = header;
        this.getOffset();
        this.getSize();
        this.getCapacity();
    }

    final int getCapacity() {
        int ret = this.header[this.CAPACITY_INDEX];
        if (ret < 0) {
            throw new IllegalStateException();
        }
        return ret;
    }

    final void setCapacity(int a) {
        this.header[this.CAPACITY_INDEX] = a;
    }

    final int getSize() {
        int ret = this.header[this.SIZE_INDEX];
        if (ret < 0) {
            throw new IllegalStateException();
        }
        if (ret > this.getCapacity()) {
            throw new IllegalStateException();
        }
        return ret;
    }

    final void setSize(int a) {
        this.header[this.SIZE_INDEX] = a;
    }

    public final int getCount() {
        return this.header[this.COUNT_INDEX];
    }

    final void setCount(int a) {
        this.header[this.COUNT_INDEX] = a;
    }

    public final int getOffset() {
        int ret = this.header[this.OFFSET_INDEX];
        if (ret < -1) {
            throw new IllegalStateException();
        }
        return ret;
    }

    final void setOffset(int a) {
        this.header[this.OFFSET_INDEX] = a;
    }

    final int getExtra(int index) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException();
        }
        return this.header[this.EXTRA_INDEX + index];
    }

    final void setExtra(int index, int a) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException();
        }
        this.header[this.EXTRA_INDEX + index] = a;
    }
}

