package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;

public class DirectObjectsFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializer deserializer) throws DatabaseException {
        DirectObjects result = reference(deserializer);
        IntArray ia = IntArray.deserialize(deserializer);
        result.setResult(ia);
        result.setReady();
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializer deserializer) throws DatabaseException {
        return (T)deserializer.readDirectObjects();
    }

}
