package org.simantics.db.impl.graph;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;

public class SingleObjectProcedure implements IntProcedure {

	final private QueryProcessor processor;
	private DatabaseException exception;
	private Resource result;
	
	public SingleObjectProcedure(QueryProcessor processor) {
		this.processor = processor;
	}
	
	@Override
	public void execute(ReadGraphImpl graph, int i) {
		Resource resource = processor.querySupport.getResource(i);
		if(result != null) {
			exception = new NoSingleResultException("", 2);
		} else {
			result = resource;
		}
	}

	@Override
	public void finished(ReadGraphImpl graph) {
		if(result == null) exception = new NoSingleResultException("", 0);
	}

	@Override
	public void exception(ReadGraphImpl graph, Throwable throwable) {
		if(throwable instanceof DatabaseException) exception = (DatabaseException)throwable;
		else throwable = new DatabaseException(throwable);
	}
	
	public Resource get() throws DatabaseException {
		if(exception != null) throw exception;
		else return result;
	}

}
