/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class GraphPrinter {

    public static String LOG_FILE = "d:\\graph.dot";
    
    public static boolean LOG = true;

    static Object loggerCreationLock = new Object();
    static GraphPrinter logger = null; 

    DataOutput log;

    public GraphPrinter() {
        if(LOG) {
            try {
                FileOutputStream stream = new FileOutputStream(LOG_FILE);
                log = new DataOutputStream(stream);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static GraphPrinter getInstance() {
        if(logger == null) {
            synchronized (loggerCreationLock) {
                if(logger == null)
                    logger = new GraphPrinter();	
            }			 
        }
        return logger;
    }

    public void begin(String filename) {
        if(LOG) {
            try {
                FileOutputStream stream = new FileOutputStream(LOG_FILE);
                log = new DataOutputStream(stream);
                try {
                    synchronized(log) {
                        log.writeBytes("digraph test {\n");
                    }
                } catch(IOException e) {
                    e.printStackTrace();
                }
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void finish() {
        if(LOG) {
            try {
                synchronized(log) {
                    log.writeBytes("}\n");
                }
            } catch(IOException e) {
                e.printStackTrace();
            }
            log = null;
        }
    }

    private String escape(String input) {
        return input.replace("[", "_").replace("]", "_").replace(":", "_").replace("/", "_").replace("@", "_").replace(".", "_").replace(" ", "_").replace("#", "_").replace("-", "_");
    }
    
    public void log(String start, String end) {

        try {
            synchronized(log) {
                log.writeBytes(escape(start.toString()));
                log.writeBytes(" -> ");
                log.writeBytes(escape(end.toString()));
                log.writeBytes("\n");
            }
        } catch(IOException e) {
            e.printStackTrace();
        }
        
    }
    
}
