/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl;

import java.io.InputStream;

import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ClusterUID;

public interface ClusterSupport {

    /**
     * For cluster's constructor to get short cluster id for the lifetime of cluster in question.
     *
     * @param clusterUID
     * @param clusterId
     * @return
     */
    int createClusterKeyByClusterUID(ClusterUID clusterUID, long clusterId);

    ClusterBase getClusterByClusterUIDOrMake(ClusterUID clusterUID);
    ClusterBase getClusterByClusterId(long clusterId);
    ClusterBase getClusterByClusterKey(int clusterKey);
    int getClusterKeyByClusterUIDOrMake(ClusterUID clusterUID);
    int getClusterKeyByClusterUIDOrMake(long id1, long id2);
    /**
     * @param resourceKey
     * @return cluster owning the given resource.
     */
    ClusterBase getClusterByResourceKey(int resourceKey);

    long getClusterIdOrCreate(ClusterUID clusterUID);

    void addStatement(Object cluster);
    void cancelStatement(Object cluster);
    void removeStatement(Object cluster);
    void cancelValue(Object cluster);
    void removeValue(Object cluster);
    void setValue(Object cluster, long clusterId, byte[] bytes, int length);
    void modiValue(Object cluster, long clusterId, long voffset, int length, byte[] bytes, int offset);
    void setImmutable(Object cluster, boolean immutable);
    void setDeleted(Object cluster, boolean deleted);
    void createResource(Object cluster, short resourceIndex, long clusterId);
    void addStatementIndex(Object cluster, int resourceKey, ClusterUID clusterUID, byte op);
    void setStreamOff(boolean setOff);
    boolean getStreamOff();

    InputStream getValueStreamEx(int resourceIndex, long clusterId)
    throws DatabaseException;
    byte[] getValueEx(int resourceIndex, long clusterId)
    throws DatabaseException;
    byte[] getValueEx(int resourceIndex, long clusterId, long voffset, int length)
    throws DatabaseException;
    long getValueSizeEx(int resourceIndex, long clusterId)
    throws DatabaseException;
    int wait4RequestsLess(int limit)
    throws DatabaseException;

    Session getSession();
    IClusterTable getClusterTable();

}
