package org.simantics.datatypes.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.adt.Color;
import org.simantics.datatypes.conversion.RGBIntegerColorAdapter;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;

public class RGBIntegerRelatedAdapter extends SimpleContextualAdapter<Color, RelationContext> {

    public static final Binding BINDING = Bindings.getBindingUnchecked(RGBIntegerColorAdapter.class);
    
	@Override
	public Color adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
		return graph.getValue(context.getStatement().getObject(), BINDING);
	}

}
