/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;

/**
 * The example demonstrates how to create and use serializer. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class SerializerExample1 {
		
	public static void main(String[] args) throws IOException, SerializationException, BindingException
	{
		// Initializer rectangle, binding and serializer 
		Rectangle2D rect = new Rectangle2D.Double(5, 5, 100, 200);
		Binding rectangleBinding = Bindings.getBindingUnchecked(Rectangle2D.Double.class);
		Serializer rectangleSerializer = Bindings.getSerializerUnchecked( rectangleBinding );

		// Serializer
		byte data[] = rectangleSerializer.serialize( rect );
		System.out.println(Arrays.toString( data ));
		
		// Deserialize
		Rectangle2D rect2 = (Rectangle2D) rectangleSerializer.deserialize(data);
		System.out.println( Bindings.toString(rect2) );		
	}
	

}

