/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;

import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.Accessor.Listener;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.impl.ChangeSet;
import org.simantics.databoard.accessor.interestset.InterestSet;

public class AccessorExample {

	public static void main(String[] args) throws Exception {
		
		//
		// Accessor is a generic interface to access some kind of data.
		// It doesn't say anything about the how data is stored in backend. 
		//
		// But!, there are many rules how the data is accessed.
		//
		// Some are in the interface and some are implemenation specific. 
	    //
		// The structure of the data must follow or be adaptable to the type system
		// of databoard.
		//
		
		
		
		// Lets create a java object, a record
		Rectangle2D rect = new Rectangle2D.Double(10, 10, 200, 100);
		
		// And open an accessor to the object		
		RecordAccessor ra = (RecordAccessor) Accessors.getAccessor(rect);
		
		// Note, the rule of java accessor type is that the instance must not be
		// modified directly while an accessor is used.
		
		
		
		// We can see the fields of the rectangle as the tree structure of the 
		// accessor is represented in the format of databoard's type system.   
		System.out.println("Type: ");
		System.out.println(ra.type());
		
		// Lets modify x-field of the rect instance
		ra.getFieldAccessor("x").setValue( Bindings.DOUBLE, 100.0);
		
		// Lets print it out
		System.out.println( rect );
		
		
		
		// Listen to changes, all changes.. 
		InterestSet is = InterestSet.newInterestSet(ra.type(), true, true, true); 
		Listener listener = new Accessor.Listener() {
			public void onEvents(Collection<Event> events) {
				for (Event e : events)
					System.out.println("Event occured: "+e);
			}
		};
		ra.addListener(listener, is, null, null);
		// Change y-pos to 666
		ra.getFieldAccessor("y").setValue( Bindings.DOUBLE, 666.0);		
		ra.removeListener(listener);
				
		
		
		// Capture changes into a collection
		ChangeSet changeSet = new ChangeSet();
		ra.addListener(changeSet, is, null, null);
		
		// Lets modify width and height
		ra.setFieldValue(2, Bindings.DOUBLE, 10.0);
		ra.setFieldValue(3, Bindings.DOUBLE, 10.0);
		
		// And print out changes
		System.out.println( rect );
		ra.removeListener(changeSet);
		
		System.out.println();
		System.out.println("Collected changes:");
		for (Event e : changeSet.getEvents())
			System.out.println(" o "+e);
		System.out.println();

		
		
		// We can apply the same modifications to another instance of rectangle
		Rectangle2D rect2 = new Rectangle2D.Double(0, 0, 0, 0);
		LinkedList<Event> rollback = new LinkedList<Event>();
		
		// Apply change set and gather rollback log
		Accessors.getAccessor(rect2).apply(changeSet.getAndClearEvents(), rollback);		
		System.out.println( rect2 );		
		
		// We can restore the rectangle by applying the rollback log 
		Accessors.getAccessor(rect2).apply(rollback, null);
		System.out.println( rect2 );		
		
		
		// Java Accessor can be left for garbage collection
		ra = null;
	}
	
}

