/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.awt.geom.Rectangle2D;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.Bean;

public class TestBeanMaker {

	public static class MyClass extends Bean {
		public @Optional String name;
		public @Identifier Long id;
	}
	
	public @Test void doTest() throws BindingConstructionException, BindingException {
		MyClass x = new MyClass();
		x.name = "hi";
		x.id = 5L;	
		
		RecordType rt = new RecordType();
		rt.addComponent("name", new OptionalType( new StringType() ) );
		rt.addComponent("id", new LongType() );
		rt.setIdentifiers(1);
		
		Binding binding = Bindings.getBeanBinding( rt );
		Bean bean = (Bean) binding.createDefault();
		bean.readFrom(x);		
		
		System.out.println(bean);
		System.out.println(bean.getBinding().getClass());
		System.out.println(binding.getClass());
		
		VariantBinding vb = (VariantBinding) Bindings.getBinding( Bean.class );
		Bean rectangleBean = (Bean) vb.create( Bindings.getBinding(Rectangle2D.Double.class), new Rectangle2D.Double(1,2,3,4) );
		System.out.println(rectangleBean.toString());
		System.out.println(rectangleBean.getBinding().getClass());
	
		UnionType ut = new UnionType();
		ut.addComponent("type1", rt);
		RecordType rt2 = new RecordType();
		rt2.addComponent("name", new OptionalType( new StringType() ) );
		rt2.addComponent("id", new LongType() );
		rt2.setIdentifiers(1);
		ut.addComponent("type2", rt2);
		Binding ub = Bindings.getBeanBinding( ut );
		
		Object u = ub.createDefault();
		System.out.println( ub.toString(u) );
		
	}
	
}
