/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util.binary;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * Writeable context
 * 
 * Common interface for ByteBuffer, byte[], OutputStream, RandomAccessFile.
 * 
 * @see ByteBufferWriteable
 * @see OutputStreamWriteable 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface BinaryWriteable extends DataOutput {

    /**
     * Put n bytes from the remaining of the byte array. 
     * This operation moves the pointer in byte buffer.
     * 
     * @param src
     * @throws IOException
     */
    void writeFully(ByteBuffer src) throws IOException;
    
    /**
     * Put n bytes from the remaining of the byte buffer. 
     * This operation moves the pointer in byte buffer.
     * 
     * @param src
     * @param length
     * @throws IOException
     */
    void writeFully(ByteBuffer src, int length) throws IOException;

	/**
	 * Flush write buffer 
	 * 
	 * @throws IOException
	 */
	void flush()
	throws IOException;
	
}

