/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.util.IdentityPair;

public class VariantType extends Datatype {
	
	public VariantType() {		
	}
	
    @Override
    public int getComponentCount() {
    	return 0;
    }
    
    @Override
    public Datatype getComponentType(int index) {
    	throw new IllegalArgumentException();
    }
    
    @Override
    public Datatype getComponentType(ChildReference path) {
    	if (path==null) return this;
    	throw new IllegalArgumentException();
    }
	
	@Override
	protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof VariantType;		
	}	
	
	@Override
	public int hashCode() {
		return 192837465 + super.hashCode();
	}
		
    @Override
    public <T> T accept(Visitor<T> v) {    	
    	return v.visit(this);
    }
    
    @Override
    public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
    }
    
	@SuppressWarnings("unchecked")
	@Override
	public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
		if (reference==null) return (T) this;		
		throw new ReferenceException("Cannot get variant type without instance");
	}
    

}

