/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.primitives;

public class MutableInteger extends Number implements Comparable<MutableInteger> {

	private static final long serialVersionUID = 1L;
	
	public int value;
	
	public MutableInteger() {}
	
	public MutableInteger(int value) { this.value = value; }
	
	public byte byteValue() {
		return (byte) value;
	}

	public short shortValue() {
		return (short) value;
	}

	public int intValue() {
		return value;
	}

	public long longValue() {
		return (long) value;
	}

	public float floatValue() {
		return (float) value;
	}

	public double doubleValue() {
		return (double) value;
	}

	public String toString() {
		return String.valueOf(value);
	}

	public int hashCode() {
		return value;
	}

	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (obj == this) return true;

		if (obj instanceof MutableInteger) {
			return value == ((MutableInteger) obj).intValue();
		}
		return false;
	}
	
    public int compareTo(MutableInteger anotherInteger) {
    	int thisVal = this.value;
    	int anotherVal = anotherInteger.value;
    	return (thisVal<anotherVal ? -1 : (thisVal==anotherVal ? 0 : 1));
    }
    
}
